#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "sMotor.h"
#include "Draw.h"

// Devices
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
sMotor motor(A0, A1, A2, A3);
int step_speed = 2200;
int numstep = 1;
DigitalOut led(D8);
Draw draw;

int main()
{
    // Variables
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t touches = 0;
    bool touched;
    
    //Initial conf
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    lcd.Clear(LCD_COLOR_RED);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.SetFont(&Font24);
    
    //Start screen
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Smart Home Controller", CENTER_MODE);
    wait(2);
    lcd.Clear(LCD_COLOR_RED);
    
    while(1) {
        // Drawing GUI
        x = TS_State.touchX[idx];
        y = TS_State.touchY[idx];
        sprintf((char*)text, "Touch %d: x=%d y=%d    ", touches, x, y);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
        ts.GetState(&TS_State);
        lcd.FillRect(0, 192, 80, 80);
        lcd.FillRect(133, 192, 80, 80);
        lcd.FillRect(266, 192, 80, 80);
        lcd.FillRect(399, 192, 80, 80);
        
        if ((TS_State.touchDetected == 0) && (touched == true)){
            touches++;
            touched = false;
        }
        if (TS_State.touchDetected == 1){
            touched = true;
        }
        
        // Button 1
        if ((TS_State.touchDetected) && (TS_State.touchX[0] < 100) && (TS_State.touchY[0] > 190 )){
            led = 1;
        }
        else{
            led = 0;
        }
        
        // Button 2
        if ((TS_State.touchDetected) && (TS_State.touchX[0] > 130) && (TS_State.touchX[0] < 210) && (TS_State.touchY[0] > 190 )){
            motor.step(numstep,0,step_speed);            
        }
        
        // Button 3
        if ((TS_State.touchDetected) && (TS_State.touchX[0] > 240) && (TS_State.touchX[0] < 320) && (TS_State.touchY[0] > 190 ))
        {
            lcd.Clear(LCD_COLOR_RED);
            lcd.DrawBitmap(0, 0, (uint8_t *)draw.GetStarWars());
            wait(5);
        }
        
        // Button 4
        if ((TS_State.touchDetected) && (TS_State.touchX[0] > 350) && (TS_State.touchX[0] < 430) && (TS_State.touchY[0] > 190 ))
        {
            
        }
    }
}
