/* This code is written for EMILY the robot Waitress */
#include "motorDriver.h"
/*============================================================================*/
//                            acceleration speed in ms
int accSpeed = 500;  
int BatteryPubTime =2000;


/*============================================================================*/


motorDriver::motorDriver(PinName Left1, PinName Left2, PinName Right1, PinName Right2, PinName PWML, PinName PWMR /*, PinName spdReadL, PinName spdReadR, PinName Bat*/):  
speedLeft1(Left1), speedLeft2(Left2),  speedRight1(Right1),  speedRight2(Right2) , pwmL(PWML), pwmR(PWMR)/*, speedReadL(spdReadL), speedReadR(spdReadR), BatteryRead(Bat)*/
{
    //initial conditions of PWM left and right
       pwmL.period_ms(10);
       pwmR.period_ms(10);
       
    //initial conditions of the left motor 
       speedLeft1= 0;
       speedLeft2= 0;
        
    //initial conditions of the right motor 
       speedRight1=0;
       speedRight2=0;
       
}




void motorDriver::setDirection(bool  keyForward,  bool  keyBackward, bool  keyLeft, bool  keyRight) 
{
    if(keyForward && !keyBackward && !keyLeft && !keyRight)   // forward 
    { 
          speedLeft2  = 0;
          speedRight2 = 0;
        
          if(speedLeft1 < 1 && speedRight1 <1)
          {
                 pwmL.pulsewidth_ms(0);
                 pwmR.pulsewidth_ms(0);
                 speedRight1 = 1;
                 speedLeft1  = 1;
              
                 for(int i=0; i<=10; i++)
                 {
                  pwmL.pulsewidth_ms(i);
                  pwmR.pulsewidth_ms(i);   
                  Thread::wait(accSpeed);                                  
                 }
              
          }
          
          if(speedLeft1 && speedRight1)
          {
             speedLeft1  = 1;
             speedRight1 = 1; 
           
          }       
    }   
    

if(!keyForward && keyBackward && !keyLeft && !keyRight)   // Backwards
    { 
          speedLeft1  = 0;
          speedRight1 = 0;
        
          if(speedLeft2 < 1 && speedRight2 <1)
          {
                 pwmL.pulsewidth_ms(0);
                 pwmR.pulsewidth_ms(0);
                 speedRight2 = 1;
                 speedLeft2  = 1;
              
                 for(int i=0; i<=10; i++)
                 {
                  pwmL.pulsewidth_ms(i);
                  pwmR.pulsewidth_ms(i);   
                  Thread::wait(accSpeed);                                            
                 }
              
          }
          
          if(speedLeft2 && speedRight2)
          {
             speedLeft1  = 1;
             speedRight1 = 1; 
             Thread::wait(accSpeed);   
          }    
              
    }   
    
    if(!keyForward && !keyBackward && keyLeft && !keyRight)   // Left
    { 
          speedLeft1  = 0;
          speedLeft2  = 0;
          speedRight2 = 0;
        
          if(speedRight1 <1)
          {
                 pwmR.pulsewidth_ms(0);
                 speedRight1 = 1;
              
                 for(int i=0; i<=10; i++)
                 {
                  pwmR.pulsewidth_ms(i);   
                  Thread::wait(accSpeed);                                            
                 }
              
          }
          
          if(speedRight1)
          {
             speedRight1 = 1; 
             Thread::wait(accSpeed);   
          }
    }
          
    if(!keyForward && !keyBackward && !keyLeft && keyRight)   // Right
    { 
          speedRight1 = 0;
          speedRight2 = 0;
          speedLeft2  = 0;
        
          if(speedLeft1 <1)
          {
                 pwmL.pulsewidth_ms(0);
                 speedLeft1=1;
              
                 for(int i=0; i<=10; i++)
                 {
                  pwmL.pulsewidth_ms(i);   
                  Thread::wait(accSpeed);                                            
                 }
              
          }
          
             if(speedLeft1)
          {
             speedLeft1 = 1; 
             Thread::wait(accSpeed);      
          }       
      }     
 }
    

//
//
//
//void motorDriver::getBattery()
//{
//    
//    ros::Publisher pub_battery("BatteryVoltage", &value_msg);
//    nh.initNode();
//    nh.advertise(pub_battery);
//    
//    float BatteryValue = 0;
//    float avg_value = 0;
//   
//    while(1)
//    {
//        for( int i = 0; i < 10; i++)
//       {
//            avg_value += BatteryRead;          // uitlezen spanning
//       }
//       
//        BatteryValue = (avg_value / 10);        // delen door 10 want 10 samples
//        BatteryValue = BatteryValue * 3.3;     // *3.3 Vref
//        value_msg.data = BatteryValue;
//        pub_battery.publish(&value_msg);
//        Thread::wait(BatteryPubTime);
//        nh.spinOnce(); 
//        break;
//        
//    }
//}    