#include "mbed.h"

/* Digital Out Pin Configuration */
DigitalOut RED(p21);
DigitalOut GREEN(p22);
DigitalOut BLUE(p23);

/* UART Pin Configuration */

RawSerial pc(USBTX, USBRX);//Serial LOG
Serial bt(p9, p10); // tx, rx to Bluetooth         


int main(void)
{   
    /* baudrate configuration */
    pc.baud(9600);
    bt.baud(9600);
    
    pc.printf("Bluetooth RGB LED terminal\n\r"); //pc.printf("WIZwiki-W7500 BT\n\r");
    bt.printf("Bluetooth RGB LED terminal\n\r"); //pc.printf("WIZwiki-W7500 BT\n\r");
    
    char ch;
    char msg[256];
    
    while(1)
    {
        /* WIZwiki-W7500 to Bluetooth */
        if(pc.readable())
        {
            pc.printf("%s",&msg);
            bt.printf("%s",msg);
        }
        
        /* Bluetooth to WIZwiki-W7500 */
        if(bt.readable())
        {
            ch = bt.getc();
            pc.putc(ch);
            
            /* Control 3 colors LED */
            if(ch == 'r'){
                RED = !RED;
                /* Notice RED LED condition to Bluethooth */
                if(RED == 0)    bt.printf("RED OFF\n\r");
                else            bt.printf("RED ON\n\r");
            }else if(ch == 'g'){
                GREEN = !GREEN;
                /* Notice GREEN LED condition to Bluethooth */
                if(GREEN == 0)    bt.printf("GREEN OFF\n\r");
                else              bt.printf("GREEN ON\n\r");
            }else if(ch == 'b'){
                BLUE = !BLUE;
                /* Notice BLUE LED condition to Bluethooth */
                if(BLUE == 0)    bt.printf("BLUE OFF\n\r");
                else             bt.printf("BLUE ON\n\r");
            }
        }
        
    }
}
