#include "mbed.h"
#include "ADXL345.h"
#include "TextLCD.h"

ADXL345 accelerometer(p5, p6, p7, p8); // (SDA, SDO, SCL, CS);
Serial pc(USBTX, USBRX); //For raw data
TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2); // rs, e, d4-d7

float x,y,z;


int main()
{

    int readings[3] = {0, 0, 0};

    lcd.cls();
    lcd.printf("Starting ADXL345 test...\n");
    lcd.printf("Device ID is: 0x%02x\n", accelerometer.getDevId());
        pc.printf("Starting ADXL345 test...\n");
        pc.printf("Device ID is: 0x%02x\n", accelerometer.getDevId());

    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);

    //Full resolution, +/-4g, 3.9mg/LSB.
    accelerometer.setDataFormatControl(0x0B);

    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);

    //Measurement mode.
    accelerometer.setPowerControl(0x08);

    while (1) {

        wait(0.1); //Intaval

        accelerometer.getOutput(readings);

        x=(int16_t)readings[0];
        x=x*4e-3;
        y=(int16_t)readings[1];
        y=y*4e-3;
        z=(int16_t)readings[2];
        z=z*4e-3;

        //13-bit, sign extended values.
        lcd.cls();
        lcd.printf("%.1f, %.1f, %.1f\n", x,y,z); //Convertet to G
        lcd.printf(" X    Y    Z  ");
            pc.printf("%i, %i, %i\n\r", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]); //Raw data

    }

}