/* mbed Microcontroller Library
 *******************************************************************************
 * Copyright (c) 2016, STMicroelectronics
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of STMicroelectronics nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************
 */
#ifndef MBED_PINNAMES_H
#define MBED_PINNAMES_H

#include "cmsis.h"
#include "PinNamesTypes.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
  ALT0 = 0x100,
  ALT1 = 0x200,
  ALT2 = 0x300,
  ALT3 = 0x400
} ALTx;

typedef enum {
  PA_0  = 0x00,
  PA_1  = 0x01,
  PA_1_ALT0 = PA_1|ALT0,
  PA_2  = 0x02,
  PA_2_ALT0 = PA_2|ALT0,
  PA_3  = 0x03,
  PA_3_ALT0 = PA_3|ALT0,
  PA_4  = 0x04,
  PA_4_ALT0 = PA_4|ALT0,
  PA_5  = 0x05,
  PA_6  = 0x06,
  PA_6_ALT0 = PA_6|ALT0,
  PA_7  = 0x07,
  PA_8  = 0x08,
  PA_9  = 0x09,
  PA_10 = 0x0A,
  PA_11 = 0x0B,
  PA_12 = 0x0C,
  PA_13 = 0x0D,
  PA_14 = 0x0E,
  PA_15 = 0x0F,
  PA_15_ALT0 = PA_15|ALT0,

  PB_0  = 0x10,
  PB_1  = 0x11,
  PB_1_ALT0 = PB_1|ALT0,
  PB_2  = 0x12,
  PB_3  = 0x13,
  PB_3_ALT0 = PB_3|ALT0,
  PB_4  = 0x14,
  PB_4_ALT0 = PB_4|ALT0,
  PB_5  = 0x15,
  PB_5_ALT0 = PB_5|ALT0,
  PB_6  = 0x16,
  PB_7  = 0x17,
  PB_8  = 0x18,
  PB_9  = 0x19,
  PB_10 = 0x1A,
  PB_11 = 0x1B,
  PB_12 = 0x1C,
  PB_13 = 0x1D,
  PB_13_ALT0 = PB_13|ALT0,
  PB_14 = 0x1E,
  PB_14_ALT0 = PB_14|ALT0,
  PB_15 = 0x1F,
  PB_15_ALT0 = PB_15|ALT0,

#ifndef STM32L433_48PINS // 48 pin versions don't have PC0-PC15 pins
  PC_0  = 0x20,
  PC_1  = 0x21,
  PC_2  = 0x22,
  PC_3  = 0x23,
  PC_4  = 0x24,
  PC_5  = 0x25,
  PC_6  = 0x26,
  PC_7  = 0x27,
  PC_8  = 0x28,
  PC_9  = 0x29,
  PC_10 = 0x2A,
  PC_11 = 0x2B,
  PC_12 = 0x2C,
#endif
  PC_13 = 0x2D,
  PC_14 = 0x2E,
  PC_15 = 0x2F,

    
  PD_2  = 0x32,
#ifdef STM32L433_100PINS // LQFP100 or UFBGA100 versions
  PD_0  = 0x30,
  PD_1  = 0x31,
  PD_3  = 0x33,
  PD_4  = 0x34,
  PD_5  = 0x35,
  PD_6  = 0x36,
  PD_7  = 0x37,
  PD_8  = 0x38,
  PD_9  = 0x39,
  PD_10 = 0x3A,
  PD_11 = 0x3B,
  PD_12 = 0x3C,
  PD_13 = 0x3D,
  PD_14 = 0x3E,
  PD_15 = 0x3F,
    
  PE_0  = 0x40,
  PE_1  = 0x41,
  PE_2  = 0x42,
  PE_3  = 0x43,
  PE_4  = 0x44,
  PE_5  = 0x45,
  PE_6  = 0x46,
  PE_7  = 0x47,
  PE_8  = 0x48,
  PE_9  = 0x49,
  PE_10 = 0x4A,
  PE_11 = 0x4B,
  PE_12 = 0x4C,
  PE_13 = 0x4D,
  PE_14 = 0x4E,
  PE_15 = 0x4F,
#endif

  PH_0  = 0x70,
  PH_1  = 0x71,

  PH_3  = 0x73,

  // ADC internal channels
  ADC_TEMP = 0xF0,
  ADC_VREF = 0xF1,
  ADC_VBAT = 0xF2,

  // Arduino connector namings
  A0          = PA_0,
  A1          = PA_1,
  A2          = PC_3,
  A3          = PC_2,
  A4          = PC_1,
  A5          = PC_0,
    
  A6          = PA_7,
  A7          = PA_2,
    
  D0          = PA_2,
  D1          = PA_3,
  D2          = PA_12,
  D3          = PB_3,
  D4          = PB_5,
  D5          = PA_15,
  D6          = PB_10,
  D7          = PC_7,
  D8          = PB_6,
  D9          = PA_8,
  D10         = PA_11,
  D11         = PB_15,
  D12         = PB_14,
  D13         = PB_13,

  // Generic signals namings
  LED1        = PA_5,
  LED2        = PA_5,
  LED3        = PA_5,
  LED4        = PA_5,
  USER_BUTTON = PC_13,
  BUTTON1 = USER_BUTTON,
  SERIAL_TX   = PA_2,
  SERIAL_RX   = PA_3,
  USBTX       = SERIAL_TX,
  USBRX       = SERIAL_RX,
  I2C_SCL     = PB_8,
  I2C_SDA     = PB_7,
  SPI_MOSI    = D11,
  SPI_MISO    = D12,
  SPI_SCK     = D13,
  SPI_CS      = D10,
  PWM_OUT     = D9,

  //USB pins
  USB_DM = PA_11,
  USB_DP = PA_12,
  USB_NOE = PA_13,

  // Not connected
  NC = (int)0xFFFFFFFF
} PinName;

#ifdef __cplusplus
}
#endif

#endif
