#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "pca9685.h"
#include "I2Cdev.h"
#include "MPU9150.h"
#include "PinNames.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
//I2C myI2C(I2C_SCL, I2C_SDA);
//PCA9685 myPWM(1, &myI2C, 400000.0); 
PwmOut led(PC_7);
I2Cdev* myI2Cdev = new I2Cdev();
MPU9150 myImu(*myI2Cdev);
Serial pc(USBTX, USBRX);

void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    pc.printf("%d\n", pc.getc());
}


int main()
{
    pc.baud(115200);
    pc.attach(&callback);
    pc.printf("\n\nEEPROM demo started\n");
    
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t textColor[50];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    uint8_t color_r = 0;
    uint8_t color_g = 0;
    uint8_t color_b = 128;
    uint32_t color = 0xFF000000;
    enum EColorState {RED, GREEN, BLUE};
    float pwmOutput = 0.0;
    EColorState eColorState = BLUE;
    bool imuState = false;

    led.period_ms(20.0);      // 4 second period
    //led.write(0.50f);      // 50% duty cycle, relative to period
    led.pulsewidth_us(1500);
    //myPWM.init();
    //myPWM.set_pwm_duty(0, 50.0);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN DEMO", CENTER_MODE);
    
    wait(1);
    
    //myImu.initialize();
    imuState = myImu.testConnection();

    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
        if( imuState ) {
            lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"IMU INIT OK", CENTER_MODE);
        }
        else{
            lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"IMU INIT Failed", CENTER_MODE);
        }    
    }

    wait(1);
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetFont(&Font12);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);

    while(1) {

        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

            lcd.SetTextColor(LCD_COLOR_BLACK);
            sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);

            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                sprintf((char*)text, "Touch %d: x=%d y=%d", idx+1, x, y);
                lcd.DisplayStringAt(0, LINE(idx+1), (uint8_t *)&textColor, LEFT_MODE);
                lcd.DisplayStringAt(0, LINE(idx+2), (uint8_t *)&text, LEFT_MODE);
                
          
                pwmOutput = (float) (x/480.0);
                if( pwmOutput > 1.0f )
                {
                    pwmOutput = 1.0f;
                }
                led.pulsewidth_us((int)(pwmOutput*2000 + 500));      // 50% duty cycle, relative to period
                

                /**
                * @brief  Sets the LCD text color.
                * @param  Color: Text color code ARGB(8-8-8-8);
                * @retval None
                */
                if( eColorState == BLUE ) {
                    color_b++;
                    if( color_b == 255 ) {
                        eColorState = GREEN;
                        color_b = 0;
                        color_g = 128;
                    }
                }
                if( eColorState == GREEN ) {
                    color_g++;
                    if( color_g == 255 ) {
                        eColorState = RED;
                        color_g = 0;
                        color_r = 128;
                    }
                }
                if( eColorState == RED ) {
                    color_r++;
                    if( color_r == 255 ) {
                        eColorState = BLUE;
                        color_r = 0;
                        color_b = 128;
                    }
                }

                for(uint8_t i=0; i <255; i++) {
                    lcd.SetTextColor(0xFF000000 + i);
                    lcd.FillCircle(i+100, 100, 5);
                    lcd.SetTextColor(0xFF000000 + (i << 8));
                    lcd.FillCircle(i+100, 150, 5);
                    lcd.SetTextColor(0xFF000000 + (i << 16));
                    lcd.FillCircle(i+100, 200, 5);
                }

                color = 0xFF000000 + (color_r << 16) + (color_g << 8) + color_b;
                sprintf((char*)textColor, "RED %x GREEN %x BLUE %x  Color=0x%x   ", color_r, color_g, color_b, color);
                lcd.DisplayStringAt(0, LINE(idx+1), (uint8_t *)&textColor, LEFT_MODE);

                lcd.SetTextColor(color);
                lcd.FillCircle(TS_State.touchX[0], TS_State.touchY[0], 5);
            }

            // lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
        } else {
            if (!cleared) {
                
                lcd.Clear(LCD_COLOR_WHITE);
                sprintf((char*)text, "Touches: 0");
                pc.printf("Servo: %f\n", pwmOutput*2000+500);
                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
                cleared = 1;
            }
        }
    }
}
