#include "mbed.h"

Serial pc(USBTX, USBRX);
PwmOut ledB1(p21),ledR1(p22),ledG1(p23),ledB2(p24),ledR2(p25),ledG2(p26);

Ticker root;

char buffer[20];
int intR=0, intG=0, intB=0, intF=0, count=0;

float map(int x, int in_min, int in_max, float out_min, float out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

void clearBuffer()
{
    for (int n=0; n<20; n++)
        buffer[n]='\0';
}

void scanInput()
{
    char* token;
    
    //pc.printf("Input = %s\r\n", buffer);

    token = strtok(buffer, ",;");
    //pc.printf("HEXred = %s\n", token);
    intR = (atoi(token)-100);
    
    token = strtok(NULL, ",;");
    //pc.printf("HEXgreen = %s\n", token);
    intG = (atoi(token)-100);
    
    token = strtok(NULL, ",;");
    //pc.printf("HEXblue = %s\n", token);
    intB = (atoi(token)-100);
    
    token = strtok(NULL, ",;");
    //pc.printf("HEXflick = %s\n", token);
    int flip = (atoi(token)-100);
    intF = (int)map(flip, 0, 255, 0.0f, 200.0f);
    
    pc.printf("Red=%d; Grern=%d; Blue=%d; Flick=%d;\n", intR, intG, intB, intF);
    
}

void rgbOn()
{
    float valueRed = map(intR, 255, 0, 0.0f, 1.0f);
    float valueGreen = map(intG, 255, 0, 0.0f, 1.0f);
    float valueBlue = map(intB, 255, 0, 0.0f, 1.0f);
    
    ledR1.period_us(10000);
    ledR1.write(valueRed);
    ledG1.period_us(10000);
    ledG1.write(valueGreen);
    ledB1.period_us(10000);
    ledB1.write(valueBlue);
    
    ledR2.period_us(10000);
    ledR2.write(valueRed);
    ledG2.period_us(10000);
    ledG2.write(valueGreen);
    ledB2.period_us(10000);
    ledB2.write(valueBlue);
    
    //pc.printf("Red=%f; Grern=%f; Blue=%f;\n", valueRed, valueGreen, valueBlue);
    
}

void rgbOff()
{
    ledR1.write(1.0f);
    ledG1.write(1.0f);
    ledB1.write(1.0f);
    ledR2.write(1.0f);
    ledG2.write(1.0f);
    ledB2.write(1.0f);
}

void run()
{   
    if(intF > 0)
    {
        count++;
        if(count > intF/2)
        {
            rgbOff();
        }
        if(count > intF)
        {
            count=0;
            rgbOn();
        }
    }
}

int main() 
{
    rgbOff();
    pc.printf("Asal Muasal Program\n");
    root.attach(&run, 0.01f);
    
    while(1) 
    {     
        pc.gets(buffer, 16);
        if (pc.getc() == ';')  
        {   
            scanInput();
            clearBuffer();
            rgbOn();
        }
    }
}