#include "mbed.h"
#include "ADP5585.h"

/*! I2C Device found!
 *  0x12    BQ24765_TEXAS_INSTRUMENT_CHARGER
 *  0x60    ADP5585_ANALOG_DEVICE_IOE_KEYPAD
 *  0x9A    SC16IS752_NORITAKE_ITRON_VFD_GU128x64D
 *  0xA0    24AA256_ATMEL_256Kb_EEPROM
 */ 

DigitalOut led1(LED1);
DigitalOut ledKYPD(LED2);
Serial pc(USBTX, USBRX);
Ticker root; 
Ticker timer30ms;
ADP5585 keypad(p28, p27);

void scan_event(){
        char key;
    if((key = keypad.getkey()) != NULL)
                pc.printf("KEY PRESSED: -<< %c >>-\n", key);
}
    
void running()
{
    led1 = !led1;
}

int main()
{    
        pc.baud(9600);
    
        keypad.setup(4, 4, 30, p15);
    
    root.attach(&running, 0.5);
    timer30ms.attach(&scan_event, 0.03);
            
    while(1){
            if(keypad._check == true)ledKYPD = 1;
            else ledKYPD = 0;       
    };
}
