#ifndef ADP5585_H
#define ADP5585_H

#include "mbed.h"


//==============================================
/*			ADP5585 specific Event defines. 			*/
//==============================================

#define ADP5585_KEY_1		4
#define ADP5585_KEY_2		9	
#define ADP5585_KEY_3		14
#define ADP5585_KEY_4		3	
#define ADP5585_KEY_5		8
#define ADP5585_KEY_6		13
#define ADP5585_KEY_7		2
#define ADP5585_KEY_8		7
#define ADP5585_KEY_9		12
#define ADP5585_KEY_0		6
#define ADP5585_KEY_M		19
#define ADP5585_KEY_B		18
#define ADP5585_KEY_U		17
#define ADP5585_KEY_D		16
#define ADP5585_KEY_Y		1
#define ADP5585_KEY_N		11
		
//==============================================
/*			Register MAP Definitions ADP5585.			*/
//==============================================
/*Device Address ADP5585. */
#define ADP5585_DEFAULT_ADDR 				0x30
/*Register Address ADP5585. */
#define ADP5585_ADR_ID               		0x00	
#define ADP5585_ADR_INT_STATUS       		0x01
#define ADP5585_ADR_STATUS           		0x02                            
#define ADP5585_ADR_FIFO1            		0x03
#define ADP5585_ADR_FIFO2            		0x04
#define ADP5585_ADR_FIFO3            		0x05
#define ADP5585_ADR_FIFO4            		0x06
#define ADP5585_ADR_FIFO5            		0x07
#define ADP5585_ADR_FIFO6            		0x08
#define ADP5585_ADR_FIFO7            		0x09
#define ADP5585_ADR_FIFO8            		0x0A
#define ADP5585_ADR_FIFO9            		0x0B
#define ADP5585_ADR_FIFO10           		0x0C
#define ADP5585_ADR_FIFO11           		0x0D
#define ADP5585_ADR_FIFO12           		0x0E
#define ADP5585_ADR_FIFO13           		0x0F
#define ADP5585_ADR_FIFO14           		0x10
#define ADP5585_ADR_FIFO15           		0x11
#define ADP5585_ADR_FIFO16           		0x12
#define ADP5585_ADR_GPI_INT_STATUS_A  		0x13
#define ADP5585_ADR_GPI_INT_STATUS_B  		0x14
#define ADP5585_ADR_GPI_STATUS_A      		0x15
#define ADP5585_ADR_GPI_STATUS_B      		0x16
#define ADP5585_ADR_RPULL_CONFIG_A   		0x17
#define ADP5585_ADR_RPULL_CONFIG_B   		0x18
#define ADP5585_ADR_RPULL_CONFIG_C   		0x19
#define ADP5585_ADR_RPULL_CONFIG_D   		0x1A
#define ADP5585_ADR_GPI_INT_LEVEL_A			0x1B
#define ADP5585_ADR_GPI_INT_LEVEL_B			0x1C
#define ADP5585_ADR_GPI_EVENT_EN_A     		0x1D
#define ADP5585_ADR_GPI_EVENT_EN_B     		0x1E
#define ADP5585_ADR_GPI_INTERRUPT_EN_A 		0x1F
#define ADP5585_ADR_GPI_INTERRUPT_EN_B 		0x20
#define ADP5585_ADR_DEBOUNCE_DIS_A     		0x21
#define ADP5585_ADR_DEBOUNCE_DIS_B     		0x22
#define ADP5585_ADR_GPO_DATA_OUT_A     		0x23
#define ADP5585_ADR_GPO_DATA_OUT_B     		0x24
#define ADP5585_ADR_GPO_OUT_MODE_A     		0x25
#define ADP5585_ADR_GPO_OUT_MODE_B     		0x26
#define ADP5585_ADR_GPIO_DIRECTION_A 		0x27
#define ADP5585_ADR_GPIO_DIRECTION_B   		0x28
#define ADP5585_ADR_RESET1_EVENT_A     		0x29
#define ADP5585_ADR_RESET1_EVENT_B     		0x2A
#define ADP5585_ADR_RESET1_EVENT_C     		0x2B
#define ADP5585_ADR_RESET2_EVENT_A     		0x2C
#define ADP5585_ADR_RESET2_EVENT_B     		0x2D
#define ADP5585_ADR_RESET_CFG         		0x2E
#define ADP5585_ADR_PWM_OFFT_LOW       		0x2F
#define ADP5585_ADR_PWM_OFFT_HIGH      		0x30
#define ADP5585_ADR_PWM_ONT_LOW        		0x31
#define ADP5585_ADR_PWM_ONT_HIGH      		0x32
#define ADP5585_ADR_PWM_CFG           		0x33
#define ADP5585_ADR_LOGIC_CFG        		0x34
#define ADP5585_ADR_LOGIC_FF_CFG       		0x35
#define ADP5585_ADR_LOGIC_INT_EVENT    		0x36
#define ADP5585_ADR_POLL_TIME_CFG      		0x37
#define ADP5585_ADR_PIN_CONFIG_A       		0x38
#define ADP5585_ADR_PIN_CONFIG_B       		0x39
#define ADP5585_ADR_PIN_CONFIG_C       		0x3A
#define ADP5585_ADR_GENERAL_CFG      		0x3B     
#define ADP5585_ADR_INT_EN            		0x3C 

//====================================================
/* 					Register Bit Mask Definitions. 					*/
//====================================================
/* ID Register bits 0x00. */
#define ADP5585_ID_MAN_ID  					(0xF0)
#define ADP5585_ID_REV_ID  					(0x0F)
/* INT_STATUS Register bits 0x01. */
#define ADP5585_INT_STATUS_EVENT_INT   		(1 << 0)
#define ADP5585_INT_STATUS_GPI_INT     		(1 << 1)
#define ADP5585_INT_STATUS_OVERFLOW_INT 	(1 << 2)
#define ADP5585_INT_STATUS_LOGIC_INT  	 	(1 << 4)
/* STATUS Register bits 0x02. */
#define ADP5585_STATUS_EC(x)					(((x) & 0x1F) << 0)
#define ADP5585_STATUS_LOGIC_STAT  				(1 << 6)
/* INT_EN Register bits 0x3C. */
#define ADP5585_INT_EN_EVENT_IEN   				(1 << 0)
#define ADP5585_INT_EN_GPI_IEN     				(1 << 1)
#define ADP5585_INT_EN_OVERFLOW_IEN 			(1 << 2)
#define ADP5585_INT_EN_LOGIC_INT  				(1 << 4)
/* GENERAL_CFG Register bits  0x3B. */
#define ADP5585_GENERAL_CFG_RST_CFG   			(1 << 0)
#define ADP5585_GENERAL_CFG_INT_CFG   			(1 << 1)
#define ADP5585_GENERAL_CFG_CORE_FREQ(x)  		(((x) & 0x03) << 5)
#define ADP5585_GENERAL_CFG_OSC_EN  			(1 << 7)
/* PIN_CONFIG_C Register bits 0x3A. */
#define ADP5585_PIN_CONFIG_C_R0_EXTEND  	(1 << 0)
#define ADP5585_PIN_CONFIG_C_R3_EXTEND(x)	(((x) & 0x03) << 2)
#define ADP5585_PIN_CONFIG_C_R4_EXTEND	  	(1 << 5)
#define ADP5585_PIN_CONFIG_C_C4_EXTEND	  	(1 << 6)
#define ADP5585_PIN_CONFIG_C_PULL_SELECT  	(1 << 7)
/* GPI_STATUS_A Register bits 0x15. */
#define ADP5585_GPI_STATUS_GPI_1_STAT 		(1 << 0)
#define ADP5585_GPI_STATUS_GPI_2_STAT 		(1 << 1)
#define ADP5585_GPI_STATUS_GPI_3_STAT 		(1 << 2)
#define ADP5585_GPI_STATUS_GPI_4_STAT 		(1 << 3)
#define ADP5585_GPI_STATUS_GPI_5_STAT 		(1 << 4)
#define ADP5585_GPI_STATUS_GPI_6_STAT 		(1 << 5)
/* GPI_STATUS_B Register bits 0x16. */
#define ADP5585_GPI_STATUS_GPI_7_STAT  		(1 << 0)
#define ADP5585_GPI_STATUS_GPI_8_STAT  		(1 << 1)
#define ADP5585_GPI_STATUS_GPI_9_STAT  		(1 << 2)
#define ADP5585_GPI_STATUS_GPI_10_STAT  	(1 << 3)
#define ADP5585_GPI_STATUS_GPI_11_STAT  	(1 << 4)
/* GPI_STATUS_C Register bits 0x18. */
#define ADP5585_GPI_STATUS_GPI_17_STAT  	(1 << 0)
#define ADP5585_GPI_STATUS_GPI_18_STAT  	(1 << 1)
#define ADP5585_GPI_STATUS_GPI_19_STAT  	(1 << 2)
/* GPI_EVENT_EN_A Register bits 0x1D. */
#define ADP5585_GPI_EVENT_EN_GPI_1_STAT  	(1 << 0)
#define ADP5585_GPI_EVENT_EN_GPI_2_STAT  	(1 << 1)
#define ADP5585_GPI_EVENT_EN_GPI_3_STAT  	(1 << 2)
#define ADP5585_GPI_EVENT_EN_GPI_4_STAT  	(1 << 3)
#define ADP5585_GPI_EVENT_EN_GPI_5_STAT  	(1 << 4)
#define ADP5585_GPI_EVENT_EN_GPI_6_STAT  	(1 << 5)
/* GPI_EVENT_EN_B Register bits 0x1E. */
#define ADP5585_GPI_EVENT_EN_GPI_7_STAT  	(1 << 0)
#define ADP5585_GPI_EVENT_EN_GPI_8_STAT  	(1 << 1)
#define ADP5585_GPI_EVENT_EN_GPI_9_STAT  	(1 << 2)
#define ADP5585_GPI_EVENT_EN_GPI_10_STAT  	(1 << 3)
#define ADP5585_GPI_EVENT_EN_GPI_11_STAT  	(1 << 4)
/* RESET_CFG Register bits 0x2E. */
#define ADP5585_RESET_CFG_RESET_PULSE_WIDTH(x)	(((x) & 0x03) << 0)
#define ADP5585_RESET_CFG_RESET_TRIGGER_TIME(x)	(((x) & 0x07) << 2)
#define ADP5585_RESET_CFG_RST_PASSTHRU_EN		(1 << 5)
#define ADP5585_RESET_CFG_RESET1_POL			(1 << 6)
#define ADP5585_RESET_CFG_RESET2_POL			(1 << 7)
/* RESET_TRIGGER_TIME bits. */ 
#define ADP5585_RESET_CFG_RESET_TRIGGER_TIME_IMMED	0
#define ADP5585_RESET_CFG_RESET_TRIGGER_TIME_1D0SEC	1
#define ADP5585_RESET_CFG_RESET_TRIGGER_TIME_1D5SEC	2
#define ADP5585_RESET_CFG_RESET_TRIGGER_TIME_2D0SEC	3
#define ADP5585_RESET_CFG_RESET_TRIGGER_TIME_2D5SEC	4
#define ADP5585_RESET_CFG_RESET_TRIGGER_TIME_3D0SEC	5
#define ADP5585_RESET_CFG_RESET_TRIGGER_TIME_3D5SEC	6
#define ADP5585_RESET_CFG_RESET_TRIGGER_TIME_4D0SEC	7
/* RESET_PULSE_WIDTH bits. */
#define ADP5585_RESET_CFG_RESET_PULSE_WIDTH_500US	0
#define ADP5585_RESET_CFG_RESET_PULSE_WIDTH_1MS		1
#define ADP5585_RESET_CFG_RESET_PULSE_WIDTH_2MS		2
#define ADP5585_RESET_CFG_RESET_PULSE_WIDTH_10MS	3
/* PWM_CFG Register bits 0x33. */ 
#define ADP5585_PWM_CFG_PWM_EN				(1 << 0)
#define ADP5585_PWM_CFG_PWM_MODE			(1 << 1)
#define ADP5585_PWM_CFG_PWM_IN_AND			(1 << 2)
/* LOGIC_CFG Register bits 0x34. */ 
#define ADP5585_LOGIC_CFG_LOGIC_SEL(x)		(((x) & 0x07) << 0)
#define ADP5585_LOGIC_LA_INV				(1 << 3)
#define ADP5585_LOGIC_LB_INV				(1 << 4)
#define ADP5585_LOGIC_LC_INV				(1 << 5)
#define ADP5585_LOGIC_LY_INV				(1 << 6)
/* LOGIC_FF_CFG Register bits 0x35. */ 
#define ADP5585_LOGIC_FF_CFG_FF_CLR			(1 << 0)
#define ADP5585_LOGIC_FF_CFG_FF_SET			(1 << 1)
/* LOGIC_INT_EVENT_EN Register bits 0x36. */ 
#define ADP5585_LOGIC_INT_EVENT_EN_LOGIC1_INT_LEVEL		(1 << 0)
#define ADP5585_LOGIC_INT_EVENT_EN_LOGIC1_EVENT_EN		(1 << 1)
#define ADP5585_LOGIC_INT_EVENT_EN_LY1_DBNC_DIS			(1 << 2)
/* POLL_TIME_CFG Register bits 0x37. */ 
#define ADP5585_POLL_TIME_CFG_KEY_POLL_TIME(x)			(((x) & 0x03) << 0)
/* KEY_POLL_TIME bits. */
#define ADP5585_POLL_TIME_CFG_KEY_POLL_TIME_10MS		(0x00)
#define ADP5585_POLL_TIME_CFG_KEY_POLL_TIME_20MS		(0x01)
#define ADP5585_POLL_TIME_CFG_KEY_POLL_TIME_30MS		(0x02)
#define ADP5585_POLL_TIME_CFG_KEY_POLL_TIME_40MS		(0x03)

#define ADP5585_EVENT_KEY_RELEASED 		0
#define ADP5585_EVENT_KEY_PRESSED   	1

#define ADP5585_INPUT   				0
#define ADP5585_OUTPUT 					1

#define ADP5585_RISING   				0xFF
#define ADP5585_FALLING   				0xF7
#define ADP5585_HIGH      				0xF6
#define ADP5585_LOW     				0xF5

#define ADP5585_NUM_COLUMNS  			5

#define MAX_EVENTS   					48

#define ADP5585_FREQUENCY				500000

#define ADP5585_OK						"ADP_Keypad_OK"
#define ADP5585_FAIL					"ADP_Keypad_FAIL"

#define ADP_KEYMAPSIZE 					36


//=======================================================
/*                      Function.                      */
//=======================================================
struct s_callback{
    int (*f_callback)(int evt);
    uint8_t callbackType;
    uint8_t evtIndex;
};

struct event{
    uint8_t number;
    uint8_t status;
};

class ADP5585{
public:
	enum W_R
    {
        _write = 0x00,
        _read  = 0x01,
    };
    
    ADP5585(PinName sda, PinName scl, char adr = ADP5585_DEFAULT_ADDR);                 
    ~ADP5585();
    
    char *Check;
    bool _check;
		
    void setup(uint8_t row, uint8_t col, int (*sf)(int evt));

    void activateRow(uint8_t row); //mark a row for reading by the key scanner
    void activateColumn(uint8_t col); //mark column for reading by key scanner
    
    //register a callback for a given key. return 0 on success, 1 on failure
    bool registerCallback(uint8_t row, uint8_t col, int (*fn)(int evt), uint8_t type);
    
    //read all events in the fifo, call any callbacks
    void update(void);
	int setEvent(int evt);
    
    void gpioSetDirection(uint8_t gpio, uint8_t dir);
    void gpioWrite(uint8_t gpio, uint8_t val);
    bool gpioRead(uint8_t gpio);
    
    bool writeRegister(uint8_t reg, uint8_t val);
    uint8_t readRegister(uint8_t reg);
	
	char getkey(int evt8_t);
    
private:
	I2C i2c;
	char data[64];
    char w[32];
    char r[32];
    char _slaveAddress;

    uint8_t numEvents;
    event *eventMatrix[MAX_EVENTS];
    uint8_t numCallbacks;
    s_callback *callbacks[MAX_EVENTS];
    
    void createEventMatrix(void);
    uint8_t getEvent(uint8_t row, uint8_t col);
};

#endif
