#ifndef _ESPTOOL_H_
#define _ESPTOOL_H_
#include "mbed.h"
#define ESP_FLASH_BEGIN  0x02
#define ESP_FLASH_DATA   0x03
#define ESP_FLASH_END    0x04
#define ESP_MEM_BEGIN    0x05
#define ESP_MEM_END      0x06
#define ESP_MEM_DATA     0x07
#define ESP_SYNC         0x08
#define ESP_WRITE_REG    0x09
#define ESP_READ_REG     0x0a

//# Maximum block sized for RAM and Flash writes, respectively.
#define ESP_RAM_BLOCK    0x1800
#define ESP_FLASH_BLOCK  0x400

//# Default baudrate. The ROM auto-bauds, so we can use more or less whatever we want.
#define ESP_ROM_BAUD     115200

//# First byte of the application image
#define ESP_IMAGE_MAGIC  0xe9

//# Initial state for the checksum routine
#define ESP_CHECKSUM_MAGIC  0xef

//# OTP ROM addresses
#define ESP_OTP_MAC0     0x3ff00050
#define ESP_OTP_MAC1     0x3ff00054

//# Sflash stub: an assembly routine to read from spi flash and send to host
#define SFLASH_STUB "\x80\x3c\x00\x40\x1c\x4b\x00\x40\x21\x11\x00\x40\x00\x80" \
                    "\xfe\x3f\xc1\xfb\xff\xd1\xf8\xff\x2d\x0d\x31\xfd\xff\x41\xf7\xff\x4a" \
                    "\xdd\x51\xf9\xff\xc0\x05\x00\x21\xf9\xff\x31\xf3\xff\x41\xf5\xff\xc0" \
                    "\x04\x00\x0b\xcc\x56\xec\xfd\x06\xff\xff\x00\x00"
class ESPTOOL {
    
public:
    ESPTOOL(Serial& serial, PinName pinEnable, PinName pinProgram)
private:
    Serial& _serial;
    DigitalOut _pinEn, _pinPro;
    uint8_t read();
    void read(uint8_t *data, uint32_t len);
    void write(uint8_t *data, uint32_t len);
}
#endif