#include "esptool.h" 

ESPTOOL::ESPTOOL(Serial& serial, PinName pinEnable, PinName pinProgram): _pinEn(pinEnable, _pinPro(pinProgram) {
    _serial = serial;
    _serial.baud(115200);
}
uint8_t ESPTOOL::read(){
    uint8_t data = _serial.getc();
    if(data == 0xDB){
        data = _serial.getc();
        if(data == 0xDC)
            return 0xC0;
        else if(data == 0xDD)
            return 0xDB;
        else
            while(1);    
    } else 
        return data;   
}
void ESPTOOL::read(uint8_t *data, uint32_t len){
    while(len --)
        *data ++ = read();
}

void ESPTOOL:write(uint8_t *data, uint32_t len){
     uint8_t* buf_send = data, data_send;
     
     while(len--){
         data_send = *buf_send++;
        if(data_send == 0xDB){
            _serial.putc(0xDB);
            _serial.putc(0xDD);     
        } else if(data_send == 0xC0) {
            _serial.putc(0xDB);
            _serial.putc(0xDC);    
        } else {
            _serial.putc(data_send);    
        }
     }
     
}
uint8_t ESPTOOL::command(uint8_t op, uint8_t *data, uint16_t data_len, uint32_t ck, uint8_t *recv_data, uint16_t *recv_len) {
    uint8_t header[8];
    _serial.putc(0xC0);
    _serial.putc(0x00);
    write(&op, 1);
    write((uint8_t*)&data_len, 2);
    write((uint8_t*)&ck, 4);
    _serial.putc(0xC0);
    
    if(_serial.getc() != 0xC0)
        return 0;
    read(header, 8);
    
    if(header[0] != 0x01 || header[1] != op)
        return 0;
    recv_len = (uint16_t*)&header[2];
    read(recv_data, *recv_len);
    if(_serial.getc() != 0xC0)
        return 0;
        
    return 1;
}

uint8_t ESPTOOL::connect() {
    _pinEn = 0;
    _pinPro = 0;
    wait(0.2);
    _pinEn = 1;
    while(_serial.available())
        _serial.getc();
       
}
uint8_t ESPTOOL::sync(){
    uint8_t i;
    uint8_t sync_frame[5] = {0x07, 0x07, 0x12, 0x20, 0x55*32};
    uint8_t recv_frame[5];
    uint8_t recv_len;
    for(i=0; i<7; i++)
        command(ESP_SYNC, sync_frame, 5, 0, recv_frame, &faerecv_len);
}