#include "mbed.h"
#include "snail.h"
#include "sensorinterface.h"
#include "sdcard.h"
#include "MbedJSONValue.h"
#include <map>

#define DEBUG

time_t lastPollTime = 0;
time_t pollInterval = 30;

bool isBasenode = false;

sensorinterface* sif;

char localAddress[8];
char baseNodeAddress[8];
bool networkParametersUpdated = false;
bool networkParametersTimedOut = false;
 
Serial pc(USBTX, USBRX);

int main()
{
    sdcard sd = sdcard();
    
    //check if local node is basenode
    #ifdef DEBUG
        pc.printf("[MAIN] Basenode status: %i\r\n", isBasenode);
    #endif
    
    sensorinterface sensors = sensorinterface();
    sif = &sensors;
        
    while(1)
    {
        //check if it's time to poll
        if (time(NULL) - lastPollTime > pollInterval)
        {
            #ifdef DEBUG
                pc.printf("[MAIN] Requesting data...\r\n");
            #endif
            sensors.requestData();
            lastPollTime = time(NULL);
        }
        
        //if there is data waiting for us...
        if (sensors.isDataWaiting())
        {
            #ifdef DEBUG
                pc.printf("[MAIN] Data waiting, reading data...\r\n");
            #endif
            
            d_reply data = sensors.readData();
            
            #ifdef DEBUG
                pc.printf("[MAIN] Got data: ");
                for (int i = 0; i < data.readings.size(); i++)
                    pc.printf("0x%.4X|", data.readings[i]);
                pc.printf("\r\n");
            #endif
            
            //log
            sd.write(static_cast<long int>(time(NULL)), data);
        }
    }
}