#ifndef SENSORINTERFACE_H
 
#define SENSORINTERFACE_H

#include "mbed.h"
#include <map>
#include <vector>

#define I2C_TYPE_HEADER     'T'
#define I2C_REQUEST_HEADER  'R'
#define I2C_DATA_HEADER     'D'
#define I2C_TYPE_PACKET_SIZE    4

#define DEBUG

struct sensor
{
    char type;
    char packetSize;
    char readingSize;
};


struct d_reply
{
    char type;
    vector<int> readings;
};


class sensorinterface
{
    public:
        map<char, sensor> sensors;
        sensorinterface();
        void requestData();
        bool isDataWaiting();
        d_reply readData();
    private:
        map<char, sensor>::iterator currentSensor;
        int update();
        void error(int);
        sensor& findType(sensor& s, int address);
        int sendRequest(char address);
        void readySet();
        void readyUnset();
        bool ready;
        
        I2C i2c;
        InterruptIn readyLine;
};
#endif