#include <string>
#include "sdcard.h"
#include <map>

sdcard::sdcard(): sd(p5, p6, p7, p8, "sd")
{   
    //first write sometimes fails, let's ensure the first write isn't real data
    FILE *fp = fopen("/sd/boot", "w");
    fprintf(fp, "boot");
    fclose(fp);
}
 
int sdcard::write(long int time, d_reply data)
{
 
    string sd_name = "/sd/";
    string sd_location ="";
    char time_s[64];
    
    char buffer[20];
    sprintf(buffer, "%i", data.type);
    string dataTypeStr = string(buffer);
    
    sd_location = sd_name + dataTypeStr;
    mkdir(sd_location.c_str(), 0777);
    
    sprintf(time_s, "%d", time);
    sd_location += "/" + string(time_s) + ".txt";
    
    FILE *fp = fopen(sd_location.c_str(), "w");
    
    if (fp == NULL)
    {
        printf("[SD] File pointer null, failed to open file\r\n");
    }
    
    string serializedData;
    
    for (int i = 0; i < data.readings.size(); i++)
        fprintf(fp, "%i\r\n", data.readings[i]);
    
    fclose(fp);
 
    return 1;
}