#include "mbed.h"
#include "EthernetInterface.h"
#include <string>

#define DEBUG

class http
{
    public:
        string get(string address, int port, string url, int replyTimeout = 20);
        string post(string address, int port, string url, string jsonPayload, int replyTimeout = 20);
        string parse(string httpReply);
        bool isEthernetConnected();
        void connect();
    
    private:
        EthernetInterface eth;
        string receiveFromSock(TCPSocketConnection sock, int replyTimeout);
};