/*
    Pololu Servo integration
    Integration of a Pololu Micro Servo Controler for 8 Servo's
    http://www.pololu.com/catalog/product/208
    Guide: http://www.pololu.com/file/0J37/ssc03a_guide.pdf
*/

#include "mbed.h"

//-- Header -----------------------------------------------------------
class pololu_mssc {
  public: 
                pololu_mssc(PinName ptx, PinName prx, PinName rst); // Constructor
    void        move(char p_servo, char p_angle); // Move Servo(0..7) to Angle (value between 0 and 5500)
    void        reset(void); // Reset Controler
  
  private:
    DigitalOut  _rst;
    Serial*     _mssc;  
   
};

//-- Def ---------------------------------------------------------------
pololu_mssc::pololu_mssc(PinName p_tx, PinName p_rx, PinName p_rst) : _rst(p_rst)
    { //Constructor
        _mssc = new Serial( p_tx, p_rx); // create a new serial connetion
        reset();
    } 

void pololu_mssc::move(char p_servo, char p_angle)
    {
        char pos_hi,pos_low;
        int temp;
        
    
        //Convert the angle data into two 7-bit bytes
        temp   = p_angle & 0x1f80;
        pos_hi = temp >> 7;
        pos_low= p_angle & 0x7f;
    
        //Construct and send a Pololu Protocol command sentence
        _mssc -> putc(0x80);    //start byte
        _mssc -> putc(0x01);    //device id
        _mssc -> putc(0x04);    //command number
        _mssc -> putc(p_servo); //servo number
        _mssc -> putc(pos_hi);  //angle data1
        _mssc -> putc(pos_low); //angle data2
    }
    
void pololu_mssc::reset(void)
    {
        _rst =1;
        wait(0.1);
        _rst =0;
        wait(0.1);
    }

// End ClassDef

pololu_mssc servo_control(p9,p10,p8);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);

//---- Main ----------------------------------------------------------------------
int main() {
   myled = 1;
   servo_control.move(1,1000);
   wait(1);
   servo_control.move(1,4000);
   wait(1);
   servo_control.move(1,1000);
   wait(1);   
   myled2 = 1;
}


