/**
 * XBeeBeispiel
 * Eine kleine Testanwendung die von einem Arduino die Werte des SHT15 per xbee empfngt
 * die daten werden im serielle AT Modus bertragen
 * Anschlieend werden die Werte in Float convertiert und gespeichert
 * Autor: Torsten Dillenburg
 * erstellt: 11.05.2011
 */

#include "mbed.h"
#include "TextLCD.h"

Serial xbee1(p28, p27); //Serielles Objekt fr den XBEE
TextLCD    lcd(p26, p25, p24, p23, p22, p21);  // rs, e, d4-d7
DigitalOut rst1(p11); //Digital reset fr den XBee, 200ns zum reset

DigitalOut myled(LED3);//Debug ber Led 3 und 4 am mbed
DigitalOut myled2(LED4);

Serial pc(USBTX, USBRX);//serial Schnittstelle ber den  USB port zum computer

char v_char_temp[5]; // Buffer fr die Seriellen werte
int stelle;
double v_messwert[3];
bool debug = true;
bool lcd_update = false;


int main() {
    rst1 = 0; //Set reset pin to 0
    myled = 0;//Set LED3 to 0
    myled2= 0;//Set LED4 to 0
    wait_ms(1);//Wait at least one millisecond
    rst1 = 1;//Set reset pin to 1
    wait_ms(1);//Wait another millisecond
    stelle =0;
    while (1) {//Neverending Loop
        if (xbee1.readable()) {//Checking for serial comminication
            myled = 0; //Turn Led 3 Off
            v_char_temp[stelle]=xbee1.getc();
            if (debug) pc.putc(v_char_temp[stelle]);
            switch(v_char_temp[stelle]) {
                case '0': stelle++; break;
                case '1': stelle++; break;
                case '2': stelle++; break;
                case '3': stelle++; break;
                case '4': stelle++; break;
                case '5': stelle++; break;
                case '6': stelle++; break;
                case '7': stelle++; break;
                case '8': stelle++; break;
                case '9': stelle++; break;
                case '.': stelle++; break;
                case 'T': v_messwert[0] = atof(v_char_temp); lcd_update = true; break; //temp
                case 'H': v_messwert[1] = atof(v_char_temp); lcd_update = true; break; //hum
                case 'D': v_messwert[2] = atof(v_char_temp); lcd_update = true; break; //dew
                default : for(int i=stelle; i>=0; i--) {v_char_temp[i]='0';} stelle=0;//puffer lschen
            }              
            myled = 1; //Turn Led 3 on for succcessfull communication
            
        }
        if (lcd_update) 
        {
            lcd_update=false;
            lcd.cls();
            //          1234567890123456
            lcd.printf("Aussen: T H\n");
            lcd.printf("   %2.2f %2.2f",v_messwert[0],v_messwert[1]);
        }
    }
}