/**
 * XBeeBeispiel
 * Eine kleine Testanwendung die von einem Arduino die Werte des SHT15 per xbee empf&#65533;ngt
 * die daten werden im serielle AT Modus &#65533;bertragen
 * Anschlie&#65533;end werden die Werte in Float convertiert und gespeichert
 * Autor: Torsten Dillenburg
 * erstellt: 11.05.2011
 */

#include "mbed.h"
#include "TextLCD.h"
#include "PachubeClient.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

#define API_KEY "YOUR_API_Key"
#define FEED_ID YOUR_FEED_ID
#define STREAM_ID "YOUR_STREAM_ID"

Serial xbee1(p28, p27); //Serielles Objekt f&#65533;r den XBEE
TextLCD    lcd(p26, p25, p24, p23, p22, p21);  // rs, e, d4-d7
PachubeClient pachube("API_KEY");
EthernetNetIf eth;

DigitalOut rst1(p11); //Digital reset f&#65533;r den XBee, 200ns zum reset

DigitalOut myled(LED3);//Debug &#65533;ber Led 3 und 4 am mbed
DigitalOut myled2(LED4);

Serial pc(USBTX, USBRX);//serial Schnittstelle &#65533;ber den  USB port zum computer

char v_char_temp[5]; // Buffer f&#65533;r die Seriellen werte
int stelle;
double v_messwert[3];
bool debug = true;
bool lcd_update = false;
Ticker pachubeUpd;
Ticker lcdUpd;

void send_update(void) {
    double tx1, rx1;
    if (debug) pc.printf("1.");
    if (1)
    {
        if (debug) pc.printf("Sending to Pachube\n");
        const int feed_id = FEED_ID;
        const std::string stream_id = STREAM_ID;
        char val1_text[32];
        sprintf(val1_text, "%2.2f,%2.2f", v_messwert[0],v_messwert[1]);
        if (debug) pc.printf("%c",val1_text);
        pachube.PutCsv("25387", val1_text);
         if (debug) printf("Pachube result  / response : %d / %d\n", 
           pachube.Result(), pachube.Response());
       
        wait(10);
    }
}

void lcdupdate(void)
{
            lcd_update=false;
            lcd.cls();
            //          1234567890123456
            lcd.printf("Aussen: T H\n");
            lcd.printf("   %2.2f %2.2f",v_messwert[0],v_messwert[1]);
}

void setup(void)
{
    eth.setup();
    pachubeUpd.attach(&send_update,900);
    lcdUpd.attach(&lcdupdate,30);
    rst1 = 0; //Set reset pin to 0
    myled = 0;//Set LED3 to 0
    myled2= 0;//Set LED4 to 0
    wait_ms(1);//Wait at least one millisecond
    rst1 = 1;//Set reset pin to 1
    wait_ms(1);//Wait another millisecond
    stelle =0;
}

void decode(char p_zeichen)
{
            v_char_temp[stelle]=p_zeichen;
            if (debug) pc.putc(v_char_temp[stelle]);
            switch(v_char_temp[stelle]) {
                case '0': stelle++; break;
                case '1': stelle++; break;
                case '2': stelle++; break;
                case '3': stelle++; break;
                case '4': stelle++; break;
                case '5': stelle++; break;
                case '6': stelle++; break;
                case '7': stelle++; break;
                case '8': stelle++; break;
                case '9': stelle++; break;
                case '.': stelle++; break;
                case 'T': v_messwert[0] = atof(v_char_temp); lcd_update = true; break; //temp
                case 'H': v_messwert[1] = atof(v_char_temp); lcd_update = true; break; //hum
                case 'D': v_messwert[2] = atof(v_char_temp); lcd_update = true; break; //dew
                default : for(int i=stelle; i>=0; i--) {v_char_temp[i]='0';} stelle=0;//puffer l&#65533;schen
            }              
}

int main() {
    setup();
    while (1) {//Neverending Loop
        if (xbee1.readable()) {//Checking for serial comminication
           decode(xbee1.getc());
        }
    }
}