#include "PachubeClient.h"

PachubeClient::PachubeClient(const string& apiKey) : _client(), _csvContent("text/csv") {
    _client.setRequestHeader("X-PachubeApiKey", apiKey);
}

PachubeClient::~PachubeClient() {
}

// put csv method to feed
void PachubeClient::PutCsv(const string& environmentID, const string& data) {
    _csvContent.set(data);
    string uri = "http://api.pachube.com/v1/feeds/" + environmentID + ".csv?_method=put";
    _result = _client.post(uri.c_str(), _csvContent, NULL);
    _response = _client.getHTTPResponseCode();
}

// put csv method to datastream
void PachubeClient::PutCsv(const string& environmentID, const string& datastreamID, const string& data) {
    _csvContent.set(data);
    string uri = "http://api.pachube.com/v1/feeds/" + environmentID + "/datastreams/" + datastreamID + ".csv?_method=put";
    _result = _client.post(uri.c_str(), _csvContent, NULL);
    _response = _client.getHTTPResponseCode();
}

// http result and response
HTTPResult PachubeClient::Result() {
    return _result;
}
int PachubeClient::Response() {
    return _response;
}