#ifndef PACHUBECLIENT_H_
#define PACHUBECLIENT_H_

#include <mbed.h>
#include <HTTPClient.h>

class PachubeClient {

public:
    // constructor and destructor
    PachubeClient(const string& apiKey);
    virtual ~PachubeClient();

    // put csv method to feed
    void PutCsv(const string& environmentID, const string& data);

    // put csv method to datastream
    void PutCsv(const string& environmentID, const string& datastreamID, const string& data);

    // http result and response
    HTTPResult Result();
    int Response();
            
private:
    // http client and data
    HTTPClient _client;
    HTTPText _csvContent;
    
    // http result and response
    HTTPResult _result;
    int _response;
    
};

#endif // PACHUBECLIENT_H_