#include "mbed.h"


DigitalOut led1 (PA_5);
AnalogIn analog (A0);

Serial serial(PA_2,PA_3);

int main()
{
    uint16_t a0_val=0;
    float a0_volt=0;
    bool light=false;
    serial.baud(115200);
    while (1) {
        a0_val = analog.read_u16();
        a0_volt = ((float)a0_val/65535)*3.319;

        light=a0_volt<3;
        led1=light;

        serial.printf("\033[3M");
        serial.printf("Hodnota a0_val (16bit): %d\n\r", a0_val);

        if(a0_volt<3) {
            serial.printf("Napeti na vstupu A0: %.3f V  ERROR\n\r",a0_volt);
            serial.printf("\033[2A");
        } else {
            serial.printf("Napeti na vstupu A0: %.3f V  OK\n\r",a0_volt);
            serial.printf("\033[2A");
        }
        wait_ms(100);
    }
}
