/* (C) 2014 Richard Thompson (Tomo2k)
This software is Apache 2.0 licenced for this to be reused.

That said, it's trivial and rather obvious!
*/
#pragma once

#include "rtos.h"


//! Lock/Unlock Mutex using variable scope.
//! Ensures always unlocked regardless of method exit
class MutexLocker
{
public:
    //! Lock the mutex
    MutexLocker(Mutex &mutex) :
        m_mutex(mutex) {
        m_mutex.lock();
    }
    //! Unlocks on destruction
    ~MutexLocker() {
        m_mutex.unlock();
    }
private:
    Mutex &m_mutex;
    // Disable copy
    MutexLocker & operator=(const MutexLocker&);
    MutexLocker(const MutexLocker &);
};
