#include "LedStrip.h"

LedStrip::LedStrip(uint16_t pixelCount) :
    numLEDs(pixelCount)
{
    // Allocate 3 bytes per pixel:
    pixels = (uint8_t *)malloc(numPixelBytes());
    if (pixels) {
        memset(pixels, 0x00, numPixelBytes()); // Init to RGB 'off' state
    }
}

LedStrip::~LedStrip()
{
    free(pixels);
}

uint32_t LedStrip::total_luminance()
{
    uint32_t running_total;
    running_total = 0;
    for (int i=0; i< numPixelBytes(); i++)
        running_total += pixels[i];
    return running_total;
}

// Convert R,G,B to combined 32-bit color
uint32_t LedStrip::Color(uint8_t red, uint8_t green, uint8_t blue)
{
    return ((uint32_t)green << 16) | ((uint32_t)red << 8) | (uint32_t)blue;
}

// Store the rgb component in our array
void LedStrip::setPixelColor(uint16_t pixNum, uint8_t red, uint8_t green, uint8_t blue)
{
    if (pixNum < numLEDs) {
        pixels[pixNum*3  ] = green;
        pixels[pixNum*3+1] = red;
        pixels[pixNum*3+2] = blue;
    }
}

void LedStrip::setPixelR(uint16_t pixNum, uint8_t red)
{
    if (pixNum < numLEDs) {
        pixels[pixNum*3+1] = red;
    }
}

void LedStrip::setPixelG(uint16_t pixNum, uint8_t green)
{
    if (pixNum < numLEDs) {
        pixels[pixNum*3] = green;
    }
}

void LedStrip::setPixelB(uint16_t pixNum, uint8_t blue)
{
    if (pixNum < numLEDs) {
        pixels[pixNum*3+2] = blue;
    }
}

void LedStrip::setPackedPixels(uint8_t * buffer, uint32_t count)
{
    if (count > numLEDs) return;
    memcpy(pixels, buffer, (size_t) (count*3));
}

void LedStrip::setPixelColor(uint16_t pixNum, uint32_t color)
{
    if (pixNum < numLEDs) {
        pixels[pixNum*3  ] = (color >> 16);
        pixels[pixNum*3+1] = (color >>  8);
        pixels[pixNum*3+2] =  color;
    }
}
