/* (C) 2014 Richard Thompson (Tomo2k)
This software is Apache 2.0 licenced for this to be reused.

That said, it's trivial and rather obvious!
*/
#pragma once

#include "mbed.h"

//! Disable then Enable interrupts using variable scope.
//! Ensures always re-enabled regardless of method exit
class IntDisabler
{
public:
    //! Disable Interrupts
    IntDisabler() {
        __disable_irq();
    }
    //! Enables Interrupts on destruction
    ~IntDisabler() {
        __enable_irq();
    }
private:
    // Disable copy
    IntDisabler & operator=(const IntDisabler&);
    IntDisabler(const IntDisabler &);
};
