#include "mbed.h"
#include "QEI.h"

PwmOut MD_PWMB(PB_1);
DigitalOut MD_BIN1(PA_10),MD_BIN2(PA_12);

BusIn Encoder_PullUp(PA_8,PA_9);
QEI Encoder(PA_9,PA_8,NC,12,QEI::X4_ENCODING);


void motor(float speed){
    
    float speed_f;
    MD_PWMB.period_us(50);
    speed_f = fabsf(speed);

    if(speed < 0){
        MD_PWMB = speed_f;
        MD_BIN1 = 1;
        MD_BIN2 = 0; 
    }
    else if(0 < speed && speed <= 1){
        MD_PWMB = speed_f;
        MD_BIN1 = 0;
        MD_BIN2 = 1;
    }
    else{
        MD_PWMB = 1;
        MD_BIN1 = 0;
        MD_BIN2 = 0;
    }
    
}

int main(){
    
    Encoder_PullUp.mode(PullUp);
    
    while(1){
    
       printf("%d\r\n",Encoder.getPulses());
    
    }
 
}
