#include "mbed.h"

PwmOut servo(PA_9);
DigitalOut myled(LED1);
InterruptIn in(PA_10);

double captime;
Timer t;

void flip_rise(){           //risng edge interrupt
    t.start();              //Timer Start
    flag = 0;
}
    
void flip_fall(){           //falling edge interrupt
    t.stop();               //Timer Stop
    captime = t.read_us();  //captime = pulse on time[us]
    t.reset();              //reset Timer
}

int main() {
    in.rise(&flip_rise);
    in.fall(&flip_fall);
    while(1) {
        printf("%f\n\r",captime);
        servo.pulsewidth_us((captime-1500)*3/2+1500);
    }
}
