#include "mbed.h"
#include "pb.h"
#include "pb_encode.h"
#include "pb_decode.h"
#include "threeaxis.pb.h"
#include "MODSERIAL.h"

MODSERIAL pc(USBTX, USBRX, "modser"); //modified modser lib to be able to input custom stream

int main() {
    pc.baud(115200);
    gyro_message GyroOut, GyroIn;
    
    pc.claim();
    uint8_t bufferout[150];
    uint8_t bufferin[150];
    
    pb_ostream_t streamout = pb_ostream_from_buffer(bufferout, sizeof(bufferout));

    GyroOut.X=1.1;
    GyroOut.Y=2.1;
    GyroOut.Z=3.1;
    pc.printf("starting..\r\n");
    while(1){
        GyroOut.X+=0.1;
        GyroOut.Y+=0.2;
        GyroOut.Z+=0.3;
        
        pc.printf("Raw values: x: %4.2f, y: %4.2f, z: %4.2f\r\n", GyroOut.X, GyroOut.Y, GyroOut.Z); //print values before encoding
        
        if (pb_encode(&streamout, gyro_message_fields, &GyroOut)) { //encode message
            /*pc.putc('$');
            //fwrite(buffer, 1, stream.bytes_written, stdout);
            pc.printf("%s", buffer);
            pc.putc('e');
            pc.putc('n');
            pc.putc('d');
            //pc.printf("x: %4.2f, y: %4.2f, z: %4.2f\r\n", Gyro.X, Gyro.Y, Gyro.Z);
            //stream*=0; //empty stream, not working as of now but creating error on mbed
            //memset(&buffer[0], 0, sizeof(buffer)); //empty buffer*/

            //new test code:
            
            pc.printf("%s\r\n", bufferout);
        }
        
        else { //print error message if encoding fails
            pc.printf("Encoding failed: %s\n", PB_GET_ERROR(&streamout));
            return 0;
        }
        
        pc.printf("decoding...\r\n");
        pb_istream_t streamin = pb_istream_from_buffer(bufferin, sizeof(bufferin)); //create input stream
        for(int i=0;i<=streamout.bytes_written;i++) //copy output buffer to input buffer
            bufferin[i]=bufferout[i];
        if (pb_decode(&streamin, gyro_message_fields, &GyroIn)) { //decode message
            pc.printf("Decoded values: x: %4.2f, y: %4.2f, z: %4.2f\r\n", GyroIn.X, GyroIn.Y, GyroIn.Z); //print decoded values
        }
        
        else { //print error message if decoding fails
            pc.printf("Decoding failed: %s\n", PB_GET_ERROR(&streamin));
            return 0;
        }
        wait(1);
    }
}
