#include "mbed.h"               //Si se toca el pulsador comienza la secuencia de "Blinky LED" 
#include "antirrebote.h"        //Si se vuelve a presionar, se apaga el LED
    //Declaración de valores de estados
enum {ON = 0,
      OFF = 1,
      COMP = 1,
      INC = 0,
      S_OFF = 0,
      S_WAIT,
      S_ON,
      S_OUT = 0,
      S_LON, S_LOFF}; 

//Seteo de entradas y salidas
DigitalIn Puls(PTC0);   //Este tiene una configuracion PULL_UP (Presionado => "0"/ NO Presionado => "1")
DigitalOut LedRojo(LED1);

Ticker wait_puls, wait_led; //Seteo de nombres de objetos tipo "Ticker"
AntReb puls_detect;
 
//Prototipos de funciones

void SM_BLINKING_LED();
void interrupt_puls();
void interrupt_led();
//Seteo de valores iniciales de variables que funcionan como memorias
int blink = OFF,
    state_pul = 0,
    state_b,
    timeP_complete = INC,
    timeL_complete = INC;
char hab;

int main(void){   //Función de los objetos
    char Pulso;
    LedRojo=1;
    wait_puls.attach(&interrupt_puls,0.01);  //Llamará a la función "interrupt_puls" cada 0.1s (100ms)  
    wait_led.attach(&interrupt_led,0.5);    //Llamará a la función "interrupt_led" cada 0.5s (500ms)
    
   
    while(true){ //Función infinita (LOOP)
        //Llamado de las funciones
        puls_detect.setPin(PTC7);
        Pulso = puls_detect.antiRebote();
        if (Pulso==1)
            blink= !blink;
        SM_BLINKING_LED();        
    }          
}
// -------------------------------------------------------------------------------------------------------
//A partir de este comentario se realizarán las definiciones de cada función

//Máquina de estados de un "Debounce Switch" (Pulsador Antirrebote)
void SM_ANTI_REBOTE(void){   //Este switch variará según el estado del pulsador

}
//Máquina de estados del "Blinky LED" (LED Titilando)
void SM_BLINKING_LED(void){ 
    switch(state_b)
    {
    case S_OFF:
        LedRojo = 1;
        if(blink == ON)
            state_b = S_ON;
    break;
    
    case S_ON:
        if (timeL_complete == COMP){
            LedRojo = !LedRojo;
            timeL_complete = INC;
            }
        if(blink == OFF)
            state_b=S_OFF;
    break;
    }
    
}  
//Esta función hará posbile el parpadeo del LED      
void interrupt_led(void){       
    timeL_complete = COMP;
}
//Esta función hará posible el antirrebote del pulsador
void interrupt_puls(void){
puls_detect.DebTime();
}