/*
 * FreeModbus Libary: BARE Demo Application
 * Copyright (C) 2006 Christian Walter <wolti@sil.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * File: $Id: demo.c,v 1.1 2006/08/22 21:35:13 wolti Exp $
 */

/* ----------------------- System includes --------------------------------*/

/* ----------------------- Modbus includes ----------------------------------*/
#include "mbed.h"
#include "EthernetInterface.h"
#include "mb.h"
#include "mbport.h"

/* ----------------------- Defines ------------------------------------------*/
#define REG_INPUT_START 1
#define REG_INPUT_NREGS 20
#define SLAVE_ID 0x00

/* ----------------------- Static variables ---------------------------------*/
static USHORT   usRegInputStart = REG_INPUT_START;
static USHORT   usRegInputBuf[REG_INPUT_NREGS];

/* ----------------------- Start implementation -----------------------------*/

Ticker flipper; 
Serial le_pc(SERIAL_TX, SERIAL_RX);
Serial RS485(D1, D0);
DigitalIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

int i=0;
int timer=0;
char new_adr[13]="#adrADR000\r";

void flip1()
{
    le_pc.printf("\n\ri=%i\n\r",i);
    RS485.puts("#???ADR\r");
    le_pc.puts("#???ADR\r");
    if(i!=0) i=0;
    timer++;
    myled3=!myled3;
}

void flip2()
{
    le_pc.printf("\n\ri=%i\n\r",i);
    RS485.printf("%s",&new_adr[0]);
    le_pc.printf("%s",&new_adr[0]);
    if(i!=0) i=0;
    timer++;
    myled=!myled;
}
 
void flip3()
{
    RS485.puts("#000STA\r"); 
    le_pc.printf("i=%i\n\r",i);
    if(i!=0) i=0;
    myled2=!myled2;
}  


int
main( void )
{
    uint32_t var;
    unsigned short var_bon;
    
    char buffer[150];
    RS485.baud(9600);
    RS485.format(8,SerialBase::None,1);
    printf("START OF THE TESTS\n");
    eMBErrorCode    eStatus; 
    EthernetInterface eth;
    //eth.set_network("169.254.178.1","255.255.0.0","169.254.178.3");
    eth.set_network("10.64.123.43","255.255.252.0","10.64.123.254");
    eth.connect();
    printf("IP address is '%s'\n", eth.get_ip_address());
    printf("MAC address is '%s'\n", eth.get_mac_address());
    flipper.attach(&flip1, 0.5);
    
    while( timer<3 )
    {
        while(RS485.readable())
        {
            buffer[i++]=RS485.getc();
        }
        if(i>=7)
        {
            i=0;
            buffer[7]='\0';
            le_pc.printf("%s",buffer);
        }
    }
    flipper.detach();
    
    new_adr[1]=buffer[1];
    new_adr[2]=buffer[2];
    new_adr[3]=buffer[3];
    timer=0;
    
    flipper.attach(&flip2, 0.5);
    
    while( timer<3 )
    {
        while(RS485.readable())
        {
            buffer[i++]=RS485.getc();
        }
        if(i>=7)
        {
            i=0;
            buffer[7]='\0';
            le_pc.printf("%s",buffer);
        }
    }
    flipper.detach();
    
    i=0;   
    
    /* inicializacion del Stack de Modbus */
    eMBTCPInit(502);
    
    /* Enable the Modbus Protocol Stack. */
    eStatus = eMBEnable(  );
    myled2=1;      

    flipper.attach(&flip3, 2.0);
    
    myled=1;
    
    while(1)
    {
        while(RS485.readable())
        {
            buffer[i++]=RS485.getc();
        }
        if(i>=56)
        {
            i=0;
            if( buffer[54]>=48 && buffer[54]<=58) buffer[55]='\0';
            else if( buffer[53]>=48 && buffer[53]<=58 )buffer[54]='\0';
            else buffer[53]='\0';
            le_pc.printf("%s",buffer);
            
            //Adresse Pompe
            usRegInputBuf[1] = (buffer[1]-48)*100 + (buffer[2]-48)*10 + (buffer[3]-48);
            
            //Infos diverses
            usRegInputBuf[2] = buffer[7]-48; // 1 -> Pompe en marche / 0 -> Arretee
            usRegInputBuf[3] = buffer[8]-48; // 1 -> Vitesse Standby / 0 -> Vitesse nominale
            usRegInputBuf[4] = buffer[9]-48; // 1 -> Mode Standby / 0 -> Autre
            
            usRegInputBuf[5] = buffer[12]-48; // 1 -> Transistor de puissance non commandes / 0 ->sinon
            usRegInputBuf[6] = buffer[13]-48; // 1 -> Temperature moteur elevee
            usRegInputBuf[7] = buffer[14]-48; // 1 -> Courant moteur important
            
            //Vitesse en tr/min en consigne
            var = (buffer[26]-48)*10000 + (buffer[27]-48)*1000 + (buffer[28]-48)*100 + (buffer[29]-48)*10 + (buffer[30]-48) ;
            var_bon = var>>16;
            usRegInputBuf[8] = var_bon;
            usRegInputBuf[9] = (unsigned short) var;
            
            //Puissance Pompe
            usRegInputBuf[10] = (buffer[32]-48)*1000 + (buffer[33]-48)*100 + (buffer[34]-48)*10 + (buffer[35]-48) ;
            
            //Temperature Pompe
            usRegInputBuf[11] = (buffer[41]-48)*100 + (buffer[42]-48)*10 + buffer[43]-48 ;
            
            //Temps de fonctionnement Pompe
            if( buffer[53]=='\0')
            {
                usRegInputBuf[12] = 0;
                usRegInputBuf[13] = (buffer[49]-48)*1000 + (buffer[50]-48)*100 + (buffer[51]-48)*10 + buffer[52]-48 ;;    
            }
            else if( buffer[54]=='\0' ){
                var = (buffer[49]-48)*10000 + (buffer[50]-48)*1000 + (buffer[51]-48)*100 + (buffer[52]-48)*10 + (buffer[53]-48);
                var_bon = var>>16;
                usRegInputBuf[12] = var_bon;
                usRegInputBuf[13] = (unsigned short) var;
            }
            else{
                var = (buffer[49]-48)*100000 + (buffer[50]-48)*10000 + (buffer[51]-48)*1000 + (buffer[52]-48)*100 + (buffer[53]-48)*10 + (buffer[54]-48)*1;
                var_bon = var>>16;
                usRegInputBuf[12] = var_bon;
                usRegInputBuf[13] = (unsigned short) var;
            }
        }
        
        /* Here we simply count the number of poll cycles. */
        ( void )eMBPoll(  );
        //usRegInputBuf[0]++;
    }
}

eMBErrorCode
eMBRegInputCB( UCHAR * pucRegBuffer, USHORT usAddress, USHORT usNRegs )
{
    eMBErrorCode    eStatus = MB_ENOERR;
    int             iRegIndex;

    if( ( usAddress >= REG_INPUT_START )
        && ( usAddress + usNRegs <= REG_INPUT_START + REG_INPUT_NREGS ) )
    {
        iRegIndex = ( int )( usAddress - usRegInputStart );
        while( usNRegs > 0 )
        {
            *pucRegBuffer++ =
                ( unsigned char )( usRegInputBuf[iRegIndex] >> 8 );
            *pucRegBuffer++ =
                ( unsigned char )( usRegInputBuf[iRegIndex] & 0xFF );
            iRegIndex++;
            usNRegs--;
        }
    }
    else
    {
        eStatus = MB_ENOREG;
    }

    return eStatus;
}

eMBErrorCode
eMBRegHoldingCB( UCHAR * pucRegBuffer, USHORT usAddress, USHORT usNRegs, eMBRegisterMode eMode )
{
    eMBErrorCode    eStatus = MB_ENOERR;
    int             iRegIndex;

    if (eMode == MB_REG_READ)
    {
        if( ( usAddress >= REG_INPUT_START )
            && ( usAddress + usNRegs <= REG_INPUT_START + REG_INPUT_NREGS ) )
        {
            iRegIndex = ( int )( usAddress - usRegInputStart );
            while( usNRegs > 0 )
            {
                *pucRegBuffer++ =
                    ( unsigned char )( usRegInputBuf[iRegIndex] >> 8 );
                *pucRegBuffer++ =
                    ( unsigned char )( usRegInputBuf[iRegIndex] & 0xFF );
                iRegIndex++;
                usNRegs--;
            }
        }
    }

    if (eMode == MB_REG_WRITE)
    {
        if( ( usAddress >= REG_INPUT_START )
            && ( usAddress + usNRegs <= REG_INPUT_START + REG_INPUT_NREGS ) )
        {
            iRegIndex = ( int )( usAddress - usRegInputStart );
            while( usNRegs > 0 )
            {
                usRegInputBuf[iRegIndex] =  ((unsigned int) *pucRegBuffer << 8) | ((unsigned int) *(pucRegBuffer+1));
                pucRegBuffer+=2;
                iRegIndex++;
                usNRegs--;
            }
        }
    }

    return eStatus;
}


eMBErrorCode
eMBRegCoilsCB( UCHAR * pucRegBuffer, USHORT usAddress, USHORT usNCoils,
               eMBRegisterMode eMode )
{
    return MB_ENOREG;
}

eMBErrorCode
eMBRegDiscreteCB( UCHAR * pucRegBuffer, USHORT usAddress, USHORT usNDiscrete )
{
    return MB_ENOREG;
}

