#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "C12832_lcd.h"
 
 // http://mbed.org/forum/mbed/topic/2238/
 //
 //
 //
 

EthernetNetIf eth; 
HTTPClient http;
C12832_LCD lcd;

//char[] ip = "192.168.200.183";
//char[] site = "http://"+ip+"/Ethernet/watmeetik.txt";
  
int main() {
 
  // SETUP ETHERNET CONNECTION
  lcd.printf("Start\n");
  wait(1);
  lcd.printf("\r\nSetting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    lcd.printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  lcd.printf("\r\nSetup OK\r\n");
  
  
  // GET HTTP REQUEST
  HTTPText txt;
  
  HTTPResult r = http.get("http://192.168.200.183/Ethernet/watmeetik.txt", &txt);
  if(r==HTTP_OK)
  {
    lcd.printf("Result :\"%s\"\n", txt.gets()); 
  }
  else
  {
    lcd.printf("Error %d\n", r);
  }
  
  wait(1);
  lcd.cls();
  lcd.printf("\nPOST\n");
  wait(1);
  
  
    // POST HTTP REQUEST
    HTTPMap msg;
    msg["m1"] = "test1";
    //http.basicAuth("gast","gast");
    HTTPResult r2 = http.post("http://192.168.200.183/Ethernet/resultaten.txt", msg, NULL);
    
    if (r2 == HTTP_OK)
    { 
        lcd.printf("Update succesful\n");
    }
    else
    {
        printf("problem occured, returncode%d\n",r2);
    }
   
  
  
  
  while(1){}

  
  return 0;
  
}