/* ELEC2645 Gamepad Test
 * 2nd Generation
 * January 2020
 * Dr Craig A. Evans & Joshua Davy
 */



// Includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

//gdf;

Gamepad pad;
N5110 lcd;

const int bigwh[10][10] = {
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,0,0,0,0,1,0,0 },
    { 0,1,0,0,0,0,0,0,1,0 },
    { 1,0,0,0,0,0,0,0,0,1 },
    { 1,1,1,0,0,0,0,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1 },
    { 1,0,0,0,1,1,0,0,0,1 },
    { 0,1,0,0,1,1,0,0,1,0 },
    { 0,0,1,0,1,1,0,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
};

const int wheel[5][5] = {
    { 0,1,1,1,0 },
    { 1,0,0,0,1 },
    { 1,1,1,1,1 },
    { 1,0,1,0,1 },
    { 0,1,1,1,0 },
};

const int rcar[10][10] = {
    { 0,0,0,0,1,1,0,0,0,0 },
    { 0,0,1,1,1,1,1,1,0,0 },
    { 0,0,1,0,1,1,0,1,0,0 },
    { 0,0,1,0,1,1,0,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,0,1,0,0,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,0,1,0,0,1,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },
};

const int ucar[10][10] = {
    { 0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,0,1,0,0,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0 },
};

const int dcar[10][10] = {
    { 0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,0,1,0,0,1,0,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0 },

};

const int full_crash[10][10] = {
    { 0,0,1,0,0,0,0,0,1,0 },
    { 0,0,0,1,1,0,0,1,0,0 },
    { 0,0,1,1,0,1,1,0,1,0 },
    { 0,0,0,1,0,0,0,0,1,0 },
    { 0,0,0,0,1,0,0,1,0,0 },
    { 0,0,0,1,0,0,0,0,1,0 },
    { 0,0,1,0,0,1,1,1,0,0 },
    { 0,0,1,1,0,0,0,1,0,0 },
    { 0,0,0,0,1,1,1,0,0,0 },
    { 0,1,1,0,0,0,0,0,0,1 },

};

volatile int x = 29;
volatile int y = 36;
volatile int xw = 4;
volatile int yw = 17;
volatile int y_u = 48;
volatile int y_d = 0;
volatile int c = 0;
volatile int y_di0 = 15;
volatile int y_di1 = 1;
volatile int y_di2 = 36;
volatile int y_di3 = 45;
volatile int y_di4 = 23;
volatile int spe = 0;
volatile int spec = 0;
volatile int specc = 0;
volatile int i = 2000;
volatile int i1 = 500;
volatile int is = 30;
volatile int iis;
volatile int g = 0;
volatile int length1;
volatile int length2;
volatile int tt;

void start_page();
void check_start();
void bound_check();
void pos_update();
void map();
void traffic();
void dirt();
void check_crash();
void game();
void game_over();
void game_modes();
void info();
void count1();
void count2();
void tail();
void time_heist();

int main()
{
    lcd.init();
    lcd.setContrast(0.5);
    pad.init();
    while(1) {
        check_start();
        while(g != 50) {
            pad.leds_on();
            lcd.clear();
            game();
            lcd.refresh();
            wait_ms(30);
        }
        while(pad.start_pressed() == false) {

        }
        game_over();
        g = 0;
        xw = 4;
        yw = 17;
    }
}

void start_page()
{
    Direction D = pad.get_direction();
    bool Yes = pad.B_pressed();
    lcd.printString("DRIIIIIVE!",12,0);
    lcd.printString("GAME MODES",12,2);
    lcd.printString("INFO",30,3);
    if(D == S) {
        xw = 24;
        yw = 25;
    }
    if(D == N) {
        xw = 4;
        yw = 17;
    }
    lcd.drawSprite(xw,yw,5,5,( int*)wheel);
    lcd.refresh();

    if(Yes == true && xw == 4 && yw == 17) {
        g = 1;
        xw = 24;
        yw = 17;
    }
    if(Yes == true && xw == 24 && yw == 25) {
        g = 2;
    }
}

void game_modes()
{
    Direction D = pad.get_direction();
    bool Yes = pad.B_pressed();
    bool Back = pad.A_pressed();
    lcd.printString("GAME MODES",12,0);
    lcd.printString("TAIL",30,2);
    lcd.printString("TIME HEIST",12,3);
    if(D == S) {
        xw = 4;
        yw = 25;
    }
    if(D == N) {
        xw = 24;
        yw = 17;
    }
    lcd.drawSprite(xw,yw,5,5,( int*)wheel);
    lcd.refresh();

    if(Yes == true && xw == 24 && yw == 17) {
        g = 13;
    }
    if(Yes == true && xw == 4 && yw == 25) {
        g = 24;
    }
    if(Back == true) {
        g = 0;
        start_page();
        xw = 4;
        yw = 17;
    }
}

void info()
{
    bool Back = pad.A_pressed();
    lcd.printString("INFO",30,0);
    lcd.refresh();
    if(Back == true) {
        g = 0;
        start_page();
        xw = 4;
        yw = 17;
    }
}

void check_start()
{
    while(g < 10) {
        while(pad.B_pressed() == false && g == 0) {
            lcd.clear();
            wait_ms(100);
            pad.leds_on();
            wait_ms(100);
            pad.leds_off();

            start_page();
        }

        while(pad.B_pressed() == false && g == 1) {
            lcd.clear();
            wait_ms(100);
            pad.leds_on();
            wait_ms(100);
            pad.leds_off();

            game_modes();
        }

        while(pad.B_pressed() == false && g == 2) {
            lcd.clear();
            wait_ms(100);
            pad.leds_on();
            wait_ms(100);
            pad.leds_off();

            info();
        }
    }
}

void bound_check()
{
    /*if(x > 76) {
        x = 76;
    }
    if(x < 0) {
        x = 0;
    }*/
    if(x < 25) {
        x = 25;
        //c = c + 1;
    }
    if(x > 50) {
        x = 50;
        //c = c + 1;
    }
    if(y > 38) {
        y = 38;
    }
    if(y < 0) {
        y = 0;
    }
    if(y > 35) {
        y = 35;
    }
    if(y < 20) {
        y = 20;
    }
}


void pos_update()
{
    Direction D = pad.get_direction();
    float Mag = pad.get_mag();

    if(Mag > 0.2) {
        spec = 1;
        wait_ms(10);
        spec = 3;
    }

    if(pad.B_held() == true) {
        wait_ms(10);
        y = y - 1;
    }
    if(pad.Y_held() == true) {
        wait_ms(10);
        y = y + 1;
    }


    if(D == NE) {
        wait_ms(10);
        x = x + spec;
    }
    if(D == E) {
        wait_ms(10);
        x = x + spec;
    }
    if(D == SE) {
        wait_ms(10);
        x = x + spec;
    }
    if(D == SW) {
        wait_ms(10);
        x = x - spec;
    }
    if(D == W) {
        wait_ms(10);
        x = x - spec;
    }
    if(D == NW) {
        wait_ms(10);
        x = x - spec;
    }
    bound_check();
    lcd.drawSprite(x,y,10,10,( int*)rcar);
    lcd.refresh();

    if(c == 3) {
        game_over();
    }


}

void map()
{
    lcd.drawLine(26,0,26,48,1);
    lcd.drawLine(40,0,40,48,1);
    lcd.drawLine(44,0,44,48,1);
    lcd.drawLine(58,0,58,48,1);
    lcd.drawLine(24,0,24,48,2);
    lcd.drawLine(60,0,60,48,2);
    //traffic();
    dirt();

}

void traffic()
{
    lcd.drawSprite(29,y_u,10,10,( int*)ucar);
    lcd.drawSprite(47,y_d,10,10,( int*)dcar);
    y_u = y_u - 1;
    y_d = y_d + 1;

    if (y_u == 0) {
        y_u = 48;
    }

    if (y_d == 48) {
        y_d = 0;
    }

    wait_ms(10);

}

void dirt()
{
    bool Acc = pad.B_held();
    bool Break = pad.Y_pressed();
    bool Reverse = pad.Y_held();
    Direction D = pad.get_direction();
    float Mag = pad.get_mag();
    lcd.drawRect(1,y_di0,2,2,FILL_TRANSPARENT);
    lcd.drawRect(5,y_di1,2,2,FILL_TRANSPARENT);
    lcd.drawRect(10,y_di2,2,2,FILL_TRANSPARENT);
    lcd.drawRect(15,y_di3,2,2,FILL_TRANSPARENT);
    lcd.drawRect(20,y_di4,2,2,FILL_TRANSPARENT);
    lcd.drawRect(65,y_di0,2,2,FILL_TRANSPARENT);
    lcd.drawRect(73,y_di1,2,2,FILL_TRANSPARENT);
    lcd.drawRect(62,y_di2,2,2,FILL_TRANSPARENT);
    lcd.drawRect(79,y_di3,2,2,FILL_TRANSPARENT);
    lcd.drawRect(81,y_di4,2,2,FILL_TRANSPARENT);

    spe = 1;

    if(Acc == true) {
        wait_ms(50);
        y_di0 = y_di0 + spe;
        y_di1 = y_di1 + spe;
        y_di2 = y_di2 + spe;
        y_di3 = y_di3 + spe;
        y_di4 = y_di4 + spe;
    }
    if(Break == true) {
        wait_ms(50);
        y_di0 = y_di0;
        y_di1 = y_di1;
        y_di2 = y_di2;
        y_di3 = y_di3;
        y_di4 = y_di4;
    }
    if(Reverse == true) {
        wait_ms(50);
        y_di0 = y_di0 - 1;
        y_di1 = y_di1 - 1;
        y_di2 = y_di2 - 1;
        y_di3 = y_di3 - 1;
        y_di4 = y_di4 - 1;
    }
    if(D == NE) {
        wait_ms(10);
        y_di0 = y_di0 + spe;
        y_di1 = y_di1 + spe;
        y_di2 = y_di2 + spe;
        y_di3 = y_di3 + spe;
        y_di4 = y_di4 + spe;
    }
    if(D == SE) {
        wait_ms(10);
        y_di0 = y_di0 - spe;
        y_di1 = y_di1 - spe;
        y_di2 = y_di2 - spe;
        y_di3 = y_di3 - spe;
        y_di4 = y_di4 - spe;
    }
    if(D == SW) {
        wait_ms(10);
        y_di0 = y_di0 - spe;
        y_di1 = y_di1 - spe;
        y_di2 = y_di2 - spe;
        y_di3 = y_di3 - spe;
        y_di4 = y_di4 - spe;
    }
    if(D == NW) {
        wait_ms(50);
        y_di0 = y_di0 + spe;
        y_di1 = y_di1 + spe;
        y_di2 = y_di2 + spe;
        y_di3 = y_di3 + spe;
        y_di4 = y_di4 + spe;
    }

    if(y_di0 > 48) {
        y_di0 = 0;
    }
    if(y_di0 < 0) {
        y_di0 = 48;
    }
    if(y_di1 > 48) {
        y_di1 = 0;
    }
    if(y_di1 < 0) {
        y_di1 = 48;
    }
    if(y_di2 > 48) {
        y_di2 = 0;
    }
    if(y_di2 < 0) {
        y_di2 = 48;
    }
    if(y_di3 > 48) {
        y_di3 = 0;
    }
    if(y_di3 < 0) {
        y_di3 = 48;
    }
    if(y_di4 > 48) {
        y_di4 = 0;
    }
    if(y_di4 < 0) {
        y_di4 = 48;
    }
}

void check_crash()
{
    if(c == 3) {
        lcd.drawSprite(x,y,10,10,( int*)full_crash);
        lcd.refresh();
        wait_ms(100);
    }
}

void tail()
{
    count1();
    map();
    pos_update();
    check_crash();

    if (i >= 3500) {
        g = 50;
        game_over();
    }
}

void time_heist()
{
    count2();
    map();
    pos_update();
    check_crash();

    if (is <= 0) {
        g = 50;
        game_over();
    }
}

void game()
{
    if(g == 13) {
        tail();
    }
    if(g == 24) {
        time_heist();
    }
    lcd.refresh();
}

void game_over()
{
    lcd.clear();
    lcd.refresh();
    lcd.printString("GAME OVER!",12,2);
    lcd.printString("Press start",10,4);
        i = 2000;
        i1 = 500;
        is = 30;
}

void count1()
{
    bool cou = pad.B_held();
    bool couu = pad.B_pressed();
    bool cu = pad.Y_held();
    bool cuu = pad.Y_pressed();

    int length;
    char buffer[5];
    if(cou == true || couu == true) {
        i = i - 5;
    }
    if(cou == false || couu == false) {
        i = i + 2;
    }
    if(cu == true || cuu == true) {
        i = i + 4;
    }

    if(i < 0) {
        i = 0;
    }
    length = sprintf(buffer, "%2dM", i);
    if(length <= 5) {
        lcd.printString(buffer,0,0);
    }
}

void count2()
{
    char buffer1[5];
    char buffer2[3];
    bool cou = pad.B_held();
    bool couu = pad.B_pressed();
    bool cu = pad.Y_held();
    bool cuu = pad.Y_pressed();

    length1 = sprintf(buffer1, "%2dM", i1);
    length2 = sprintf(buffer2, "%2dS", is);
    if(length1 <= 5) {
        lcd.printString(buffer1,0,0);
    }
    if(cou == true || couu == true) {
        i1 = i1 - 5;
    }
    if(cu == true || cuu == true) {
        i1 = i1 + 3;
    }

    if(i1 < 0) {
        i1 = 500;
        is = 30;
    }
    if(length2 <= 3) {
        lcd.printString(buffer2,61,0);
    }
    
    iis = 30;
    tt = tt + 1;
    if(iis == tt){
     tt = 0;
     is = is - 1;
    }
}

