#include "mbed.h"
#include "LCD_DISCO_F469NI.h"
#include "string.h"
#include "stdio.h"

Serial pc(USBTX, USBRX);
Serial esp(D1, D0); // tx, rx
DigitalOut reset(D10);
Timer t;

int  count,ended,timeout;
char buf[102400];
char snd[255];

uint8_t text[100];
char textc[100];


char ssid[32] = "TobyTechnology";     // enter WiFi router ssid inside the quotes
char pwd [32] = "19980106"; // enter WiFi router password inside the quotes

void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate();
LCD_DISCO_F469NI lcd;

int main()
{
    reset=0; //hardware reset for 8266

    reset=1;
    timeout=2;
    getreply();

    esp.baud(115200);   // change this to the new ESP8266 baudrate if it is changed at any time.

    //ESPsetbaudrate();   //******************  include this routine to set a different ESP8266 baudrate  ******************

    ESPconfig();        //******************  include Config to set the ESP8266 configuration  ***********************

    lcd.Clear(LCD_COLOR_WHITE);

    // continuosly get AP list and IP
    while(1) {
    
        
        lcd.DisplayStringAt(10, LINE(0),  (uint8_t *)"---------- Connecting ----------", LEFT_MODE );
        strcpy(snd, "AT+CIPSTART=\"TCP\",\"192.168.137.12\",80\r\n");
        SendCMD();
        timeout=5;
        getreply();
        lcd.DisplayStringAt(11, LINE(1),  (uint8_t *)buf, LEFT_MODE );
        wait(0.1);
        
        lcd.DisplayStringAt(10, LINE(5),  (uint8_t *)"---------- Sending Data ----------", LEFT_MODE );
        
        char data[500] = "GET /index.php?id=5 HTTP/1.1\r\nHost: 192.168.137.12\r\n\r\n";
        sprintf(textc,"AT+CIPSEND=%d\r\n", strlen(data));
        strcpy(snd, textc);
        SendCMD();
        timeout=3;
        getreply();
        lcd.DisplayStringAt(11, LINE(6),  (uint8_t *)buf, LEFT_MODE );
        wait(0.1);
        
        strcpy(snd, data);
        SendCMD();
        timeout=3;
        getreply();
        lcd.DisplayStringAt(11, LINE(10),  (uint8_t *)buf, LEFT_MODE );
        
//
        wait(5);
        lcd.Clear(LCD_COLOR_WHITE);
        
    }

}

// Sets new ESP8266 baurate, change the esp.baud(xxxxx) to match your new setting once this has been executed
void ESPsetbaudrate()
{
    strcpy(snd, "AT+CIOBAUD=115200\r\n");   // change the numeric value to the required baudrate
    SendCMD();
}

//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void ESPconfig()
{    
    //RESETTING
    lcd.DisplayStringAt(0, LINE(0),  (uint8_t *)"---------- Reset... ----------", LEFT_MODE );
    strcpy(snd,"AT+RST\r\n");
    SendCMD();
    timeout=1;
    getreply();
    lcd.DisplayStringAt(0, LINE(1),  (uint8_t *)"<Reset Done>", LEFT_MODE );
    
    
    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    lcd.DisplayStringAt(0, LINE(3),  (uint8_t *)"---------- Mode Setting... ----------", LEFT_MODE );
    strcpy(snd, "AT+CWMODE=1\r\n");
    SendCMD();
    timeout=1;
    getreply();
    /*
    for( int i=0 ; buf[i]!='\0' ; i++ ){
        char str[10];
        sprintf(str,"%d ",(int)buf[i]);
        lcd.DisplayStringAt(i*30, LINE(5), (uint8_t *)str, LEFT_MODE );
    }
    */
    //lcd.DisplayStringAt(0, LINE(10),  (uint8_t *)buf, LEFT_MODE );
    
    if( !strcmp( buf , "AT+CWMODE=1\r\r\n\r\nOK\r\n" ) ) 
        lcd.DisplayStringAt(0, LINE(4),  (uint8_t *)"<Mode Setting done>", LEFT_MODE );    
    else { lcd.DisplayStringAt(0, LINE(4),  (uint8_t *)"<Mode Setting failed>...FUCK...", LEFT_MODE ); wait(5); }
    
    // set CIPMUX to 0=Single,1=Multi
    lcd.DisplayStringAt(0, LINE(6),  (uint8_t *)"---------- Connection Mode Setting... ----------", LEFT_MODE );
    strcpy(snd, "AT+CIPMUX=0\r\n");
    SendCMD();
    timeout=1;
    getreply();
    
    if( !strcmp( buf , "AT+CIPMUX=0\r\r\n\r\nOK\r\n" ) ) 
        lcd.DisplayStringAt(0, LINE(7),  (uint8_t *)"<CIPMUX=0 done>", LEFT_MODE );    
    else{ lcd.DisplayStringAt(0, LINE(7),  (uint8_t *)"<Mux Setting failed>...FUCK...-", LEFT_MODE ); wait(5);}
    
    lcd.DisplayStringAt(0, LINE(9),  (uint8_t *)"---------- Connecting to AP... ----------", LEFT_MODE );
    sprintf((char*)text,"ssid = %s   pwd = %s",ssid,pwd);
    strcpy(snd, "AT+CWJAP=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=3;
    getreply();
/*
    if( !strcmp( buf ,
        "TobyTechnology\",\"19980106\"\r\nWIFI DISCONNECT\r\nWIFI CONNECTED\r\nWIFI GOT IP\r\r\n\r\nOK"  )
        lcd.DisplayStringAt(0, LINE(10),  (uint8_t *)"<WIFI Connected>", LEFT_MODE );    
    else{ lcd.DisplayStringAt(0, LINE(10),  (uint8_t *)"<WIFI Connectting failed>...FUCK...-", LEFT_MODE ); wait(5);}
*/
    
    lcd.DisplayStringAt(0, LINE(10),  (uint8_t *)"---------- Get IP... ----------", LEFT_MODE );
    strcpy(snd, "AT+CIFSR\r\n");
    SendCMD();
    timeout=1;
    getreply();
    lcd.DisplayStringAt(0, LINE(11),  (uint8_t *)buf, LEFT_MODE );

    strcpy(snd, "AT+CIPSTATUS\r\n");
    SendCMD();
    timeout=1;
    getreply();
    lcd.DisplayStringAt(0, LINE(12),  (uint8_t *)"Status:", LEFT_MODE );
    lcd.DisplayStringAt(50, LINE(12),  (uint8_t *)buf, LEFT_MODE ); wait(1);
}

void SendCMD()
{
    esp.printf("%s", snd);
}

void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}
