#include "CardList.h"

//LCD Touch Screen
#include "LCD_DISCO_F469NI.h"
#include "TS_DISCO_F469NI.h"
LCD_DISCO_F469NI lcd;

bool CardList::reg_card(int a, int b, int c, int d, CardName card ){
    
    Card new_card(a, b, c, d, card);
    _card_list.push_back(new_card);
    
    return true;
}

CardName CardList::read_card(){
    RfChip.PICC_IsNewCardPresent();// Look for new cards
    RfChip.PICC_ReadCardSerial();// Select one of the cards
    
    for(int i=0 ; i<_card_list.size() ; i++){
        if( _card_list[i].UID[0] != RfChip.uid.uidByte[0] ) continue;
        if( _card_list[i].UID[1] != RfChip.uid.uidByte[1] ) continue;
        if( _card_list[i].UID[2] != RfChip.uid.uidByte[2] ) continue;
        if( _card_list[i].UID[3] != RfChip.uid.uidByte[3] ) continue;
        
        _card_buf = _card_list[i].type;
        return _card_list[i].type;
    }
    
    return emp;
}

void CardList::print_UID(){
    
    char text[100];
    
    RfChip.PICC_IsNewCardPresent();// Look for new cards
    RfChip.PICC_ReadCardSerial();// Select one of the cards
    
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"UID:", LEFT_MODE );
    
    for(int i=0 ; i<4 ;i++ ){
        sprintf(text, "%x", RfChip.uid.uidByte[i]);
        lcd.DisplayStringAt( (i+1)*80, LINE(5), (uint8_t *)text, LEFT_MODE );
    }
}

bool CardList::is_another_card(){
    RfChip.PICC_IsNewCardPresent();// Look for new cards
    RfChip.PICC_ReadCardSerial();// Select one of the cards
    
    for(int i=0 ; i<_card_list.size() ; i++){
        if( _card_list[i].UID[0] != RfChip.uid.uidByte[0] ) continue;
        if( _card_list[i].UID[1] != RfChip.uid.uidByte[1] ) continue;
        if( _card_list[i].UID[2] != RfChip.uid.uidByte[2] ) continue;
        if( _card_list[i].UID[3] != RfChip.uid.uidByte[3] ) continue;
        
        if( _card_buf != _card_list[i].type ) return true; 
        else return false;
    }
        
    return ERR;
};

Card::Card( int a, int b, int c, int d, CardName card ) {
    
    UID[0] = a;
    UID[1] = b;
    UID[2] = c;
    UID[3] = d;
    
    type = card;

}