#include<vector>
#include "MFRC522.h"
#include"mbed.h"

#define MF_RESET    A0//RST
#define SPI_MOSI    D11
#define SPI_MISO    D12
#define SPI_SCK     D13
#define SPI_CS      D10

enum CardName{
    tray_station_0,      //0     
    tray_station_1,      //1
    seat_0,              //2
    seat_1,              //3
    seat_2,              //4
    seat_3,              //5
    seat_4,              //6
    seat_5,              //7
    seat_6,              //8             
    seat_7,              //9
    seat_8,              //10
    seat_9,              //11
    ERR = 100
};

class Card{
public:
    Card(int, int, int, int, CardName);
    int UID[4];
    CardName type;
};

class CardList{
public:
    CardList() : RfChip  (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET) {  RfChip.PCD_Init(); }; // Initial RC522 Chip 
    
    bool reg_card(int, int, int, int, CardName ); //a、Nb、c、d --> UID  type --> Card type
    CardName read_card();
    bool is_another_card();// return 1 if RFID read another card
    void print_UID(); //print UID
    
private:
    CardName _card_buf;
    vector< Card >  _card_list;    
    MFRC522 RfChip;
};

