#include "mbed.h"
#include "SerialTerm.h"

SerialTerm::SerialTerm(Serial *s)
{
    First_Command = NULL;
    serial = s;
    New_Row = false;
    Command_Len = 0;
}

void SerialTerm::Tick(void)
{
    if (New_Row)
    {
        serial->printf("> ");
        New_Row = false;
    }

    if (serial->readable())
    {
        unsigned char c = serial->getc();
        if (c != '\n')
        {
            serial->putc(c);
            Command_Buffer[Command_Len++] = c;
        }
        else
        {
            serial->printf("\n\r");
            Command_Buffer[Command_Len++] = 0;
                
            New_Row = true;
            HandleCommand();
                
            Command_Len = 0;
        }
    }
}

void SerialTerm::HandleCommand(void)
{

    int pos = 0;
    int num_args = 0;
    char cmd_split[16][16];
    char *split_entrys[16]; // HACKHACK: Couldent get it to properly send a tidy pointer to the callback that didnt need casting, made it use this instead, FIX ASAP
    for (int i = 0; i < 16; i++)
        split_entrys[i] = cmd_split[i];
    while (num_args < 16)
    {
        bool found = false;
        int a = 0;
        while (Command_Buffer[pos] == ' ' && Command_Buffer[pos] != 0)
            pos++;
        
        while (Command_Buffer[pos] != ' ' && Command_Buffer[pos] != 0)
        {
            found = true;
            
            cmd_split[num_args][a] = Command_Buffer[pos];
            
            a++;
            pos++;
        }
        cmd_split[num_args][a] = 0;
        if (found)
            num_args++;
        else
            break;
        pos++;
    }

    SerialTerm_Command *next = First_Command;
    
    if (num_args < 1)
        return;
    
    while (next)
    {
        if (strcmp(cmd_split[0], next->cmd) == 0)
        {
            return (*next->func)(num_args, split_entrys, serial);
        }
    
        next = next->next;
    }
    
    serial->printf("Unknown command '%s'\n\r", cmd_split[0]);
}

void SerialTerm::Add_Command(char *cmd, void (*func)(int argc, char **argv, Serial *s))
{
    SerialTerm_Command *command = new SerialTerm_Command;
    command->cmd = cmd;
    command->func = func;
    command->next = First_Command;
    
    First_Command = command;
}