#include "mbed.h"
//#include "rtos.h"
#include "wdt.h"
// Sample program using the Watchdog
// ---------------------------------
//    * Three threads co-operate to flash two LEDs
//    * A simple way to inject a fault, by pressing a button 
//    * The watchdog is configured with a 32ms timeout
#define ON 1
#define OFF 0
DigitalOut led_red(LED_RED, ON);
DigitalOut led_blue(LED_BLUE, ON);
DigitalOut led_green(LED_GREEN, ON);
DigitalIn button(PTD0, PullUp);
DigitalOut led1(PTC12, OFF);
DigitalOut led2(PTC13, OFF);
Serial pc(USBTX, USBRX);
// This ticker is used to feed the watch dog
Ticker tick;
// Threads
Thread threadT; // timer thread 
Thread threadLED1; // thread LED1
Thread circuitfailure;
AnalogIn ain(A0);

float volts;

// ------------Fault Injection Button-------------
//  Wait while the button is down
//     Use this to simulate a STUCK fault
// -----------------------------------------------
void waitButton() {
   
    while (!button);
}
// ---Thread for controlling LED 1----------------
//   Turn LED1 on/off in response to signals 
// -----------------------------------------------
void led1_thread() {  // method to run in thread
    osEvent evt ;
    while (true) {
        wdt_kick_all();
        evt = Thread::signal_wait(0x0); // wait for any signal
        if (evt.status == osEventSignal) {
            if (evt.value.signals & 0x01) 
            {
                led1 = ON ;
                
            }
            if (evt.value.signals & 0x02) led1 = OFF ;
        } 
    }
}

// ---Thread for timing --------------------------
//   Send signals to the other threads
// -----------------------------------------------
void timer_thread() {  // method to run in thread
    while (true) {
        Thread::wait(250) ;
        threadLED1.signal_set(0x1) ;//on
        Thread::wait(250) ;
        threadLED1.signal_set(0x2) ;//off
    }
}
void failed_circuit() 
{ 
    int counter=0;
    while (true) 
    {
        volts = ain*3.3;
        if (volts>3) 
        {if(led_blue==1) {
            pc.printf("Warning: Short Circuit\n\r");
           led_green=0;}}//turn on the green LED
        
        else
        {
           if(led1==1)
           {
                if (volts<0.1)        
                {    
                    counter++;
                    if (counter>10)
                    { if(led_green==1){
                         pc.printf("Warning: Open Circuit\n\r");
                       led_blue=0;}//turn on the blue LED
                        counter =0;
                    }
                }
               else
                { if(led_blue==1 && led_green==1){
                    pc.printf("%f volts\n\r",volts);}
                } 
            }
        }
 
       waitButton(); // POSSIBLE FAULT HERE     
    }     
}
// -----------MAIN-------------------------------
//    Configure watchdog. Start threads. 
//    Show start up with RED for 1sec
//    Remember the watchdog is running
//       - 1024ms to set it once
//       - then must feed it every 32ms  
// ----------------------------------------------

int main(void) {
    
    wdt_1sec() ; // initialise watchdog - 32ms timeout
    
    // start threads
    threadT.start(&timer_thread) ; // start the timer thread 
    threadLED1.start(&led1_thread) ; // start the LED1 control thread 
    circuitfailure.start(&failed_circuit);
    
    // show start-up
    led_red = OFF;
    Thread::wait(1000) ;//1ms
    led_red = ON;
   
}