#include "mbed.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut redLED(LED_RED);
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED(LED_BLUE);
DigitalOut led1(D8);
enum positions{LeftOut, RightOut, LeftIn, RightIn, None};
TSISensor tsi;

Thread redThread;//(osPriorityNormal, 1000); // thread for red LED
Thread greenThread;//(osPriorityNormal, 1000); // thread for green LED
Thread blueThread;//(osPriorityNormal, 1000);
Thread whiteThread;//(osPriorityNormal, 1000);
volatile int numb = 1;

void red_thread() {  // method to run in thread
        while (true) {
        Thread::signal_wait(0x1);
        redLED = !redLED ; // turn on
        //blueLED = true;
        //greenLED = true;
       // Thread::wait(5000);
       // redLED = true ; // turn off
       redThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on
    }
}

void green_thread() {  // method to run in thread
        while (true) {
        Thread::signal_wait(0x1);
        greenLED = !greenLED ; // turn on
       // blueLED = true;
        //redLED = true;
       // Thread::wait(5000);
       // greenLED = true ; // turn off
        greenThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on
    }
}

void blue_thread() {  // method to run in thread
        while (true) {
        Thread::signal_wait(0x1);
        blueLED = !blueLED ; // turn on
        //redLED = true;
        //greenLED = true;
        //Thread::wait(5000);
        //blueLED = true ; // turn off
        blueThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on
    }
}


void white_thread() {  // method to run in thread
        while (true) {
        Thread::signal_wait(0x1);
        led1 = !led1;
      //  Thread::wait(5000);
        //redLED = true ; // turn off
        //blueLED = true ; // turn off
        //greenLED = true ; // turn off
        whiteThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on
    }
}


int main(void) {
    redLED = true ; // turn off
    greenLED = true ; // turn off
    blueLED = true;
    redThread.start(&red_thread) ; // start the red thread
    greenThread.start(&green_thread) ; // start the green thread
    blueThread.start(&blue_thread) ; // start the green thread
    whiteThread.start(&white_thread) ; // start the green thread
    positions area = None;

    while (true) {

        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value
        pc.printf("%d", d) ;
        pc.putc(' ') ;
        switch (area)
        {
         
case LeftOut:

         if (d>0)

                 redLED =  redLED;
        else    if (d<3 || d>9)
                    {numb = 1;
                     area = None;
                      break;
              }
case LeftIn:
          if (d>0)
                greenLED = greenLED;
               else      if (d<13 || d > 19){
                            numb = 1;
                            area = None;
                             break;
        }
 case RightIn:
        if (d>0)
                blueLED = blueLED;
                  else  if (d< 23 || d > 29){
                          numb = 1;
                            area = None;
                            break;
        }
case RightOut:
        if (d>0)
            led1 = led1;
            else        if (d<33)
                         {numb = 1;
                          area = None;
                             break;
                        }
case None:
        if (d>3 && d < 9){
                if (numb == 1){
                 redThread.signal_set(0x1);
                numb = 0;
                area = LeftOut ;
                break;}
       }
                else if (d > 13 && d < 19)
                        {if (numb == 1){
                        greenThread.signal_set(0x1);
                        numb = 0;
                        area = LeftIn;
                         break;}
       }
                else if (d > 23 && d < 29)
                        {if (numb == 1){
                        blueThread.signal_set(0x1);
                        numb = 0;
                        area = RightIn;
                        break;}
       }

             else if (d > 33)
                    {if (numb == 1){
                    whiteThread.signal_set(0x1);
                    numb = 0;
                     area = RightOut;
                    break;}
       }
       }
        Thread::wait(200);  // This polling rate is too slow - increase it
                            // The slower rate maks it easier to output on the terminal
    }
}
