#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button(PTD0); 
InterruptIn button2(PTD2);
DigitalOut led(LED_RED);
DigitalOut led2(LED_BLUE);

volatile int change = 0;
volatile int change2 = 0;
volatile int pressEvent = 0 ;
volatile int pressEvent2 = 0;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void buttonCallback(){ //Callback for the first button
    pressEvent = 1 ;
}
void button2Callback(){ //Callback for the second button
    pressEvent2 = 1;
    }

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;   // Attach function to falling edge
    button2.mode(PullUp);
    button2.fall(&button2Callback);
//led2 = 1;      

    while(true) {
        // Toggle the LED every time the button is pressed
        if (pressEvent) {
            change = !change;
            if (change == 1){
            led = led;}
            pressEvent = 0 ; // Clear the event variable
        }
        if (pressEvent2) {
            change2=!change2;
            if(change2 == 1){
            led2 = led2;}
            pressEvent2 = 0;
            }
        if (change == 0){
        led = !led ;}
        if (change2 == 0){
        led2 = !led2;}
        Thread::wait(500);
    }
} 