// Lab 3 Example Program 2
// -----------------------
// Periodically write to the AnalogOut to create a sine wave
// Alternate between two fixed frequencies every 5 sec
//
// Updated for mbed 5

// THIS VERSION HAS NO DEBUGGING CODE

#include "mbed.h"
#include "sineTable.h"

Ticker tick ;          // Creates periodic interrupt
Ticker tick2;           // Creates another periodic interrupt
AnalogOut ao(PTE30) ;  // Analog output
AnalogIn ain(A0) ;
Serial pc(USBTX, USBRX); // tx, rx, for debugging
//volatile int t;

// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 
void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }       
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}


// Function called periodically
// Write new value to AnalogOut 
volatile int index = 0 ; // index into array of sin values
void writeAout() {
    ao.write_u16(sine[index]) ;
    index = (index + 1) % 64 ;   
}

// Control the frequency of updates
//   Alternative between two frequencies      
int main() {
    int volts = 0 ;
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;

    tick2.attach_us(callback(&readA0), 10000); // ticks every 10ms
    int update_us = 1000 ; // 1ms
    while (true) {
         osEvent evt = mailbox.get(); // wait for mail 
 if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            mailbox.free(mess) ;  // free the message space

         //t = 1000000/((1+(49*volts/330))*64);
            //update_us = t;
           update_us = 1000000/((1+(49*volts/330))*64);
            tick.attach_us(callback(&writeAout), update_us); 
           // if (volts > threshold) led1 = 0 ; else led1 = 1 ;
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
               counter = 0 ;
     }
       }
        // setup ticker to write to AnalogOut
        //Thread::wait(30000) ; // wait 30 sec - 30000ms
        // The varying update time for the ticker
        
        //tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
      //  Thread::wait(30000) ; // wait 30 sec - 30000ms
      //  update_us = 1000 ; // 1ms
    }
}
