#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z, trled, tgled, tbled;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        trled = 1.0f - abs(x);
        tgled = 1.0f - abs(y);
        tbled = 1.0f - abs(z); 
        
        if (trled>0.8 && tgled > 0.8)
        {
        rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z); 
        if (z>0){
        pc.printf("FLAT\n");    
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
            }
            else{
                pc.printf("OVER\n");    
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);}
        }
           else if (tgled > 0.8 && tbled > 0.8)
            {
               rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z); 
        if (x>0){
        pc.printf("DOWN\n");    
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
            }
            else{
                pc.printf("UP\n");    
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);}
                }
             else   if (trled>0.8 && tbled > 0.8)
                {
                rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z); 
        if (y>0){
        pc.printf("LEFT\n");    
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
            }
            else{
                pc.printf("RIGHT\n");    
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);}
                }
                else {
                   rled = 1;
        gled = 1;
        bled = 1; 
                    }
        Thread::wait(300);
       // if (gled == 0 || bled == 0 || rled == 0){
      //  pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);}
    }
}
