#include "mbed.h"
#include "IRremote.h"

#define DURATION 0.2
//#define PRINTF

#ifdef PRINTF
//Serial pc(USBTX, USBRX);
Serial pc(PA_2, USBRX);
#endif
DigitalOut led_1(PB_7); //LED_1
DigitalOut led_2(PB_6); //LED_2
DigitalOut led_3(PB_5); //LED_3
DigitalOut led_4(PB_4); //LED_4
IRrecv irrecv(PA_7);
decode_results results;

#define PowerSwitch 0xA90
//#define StopSwitch 0xA80
#define Button5 0x210

bool is_stop_received(void)
{
    if (irrecv.decode(&results))
    {
        if (results.decode_type == SONY && results.value == PowerSwitch)
        {
#ifdef PRINTF
            pc.printf("stop\r\n");
#endif
            return true;
        }
        irrecv.resume();
    }
    return false;
}

bool is_start_received(void)
{
    if (irrecv.decode(&results))
    {
        if (results.decode_type == SONY && results.value == Button5)
        {
#ifdef PRINTF
            pc.printf("start\r\n");
#endif
            return true;
        }
        irrecv.resume();
    }
    return false;
}

int main()
{
#ifdef PRINTF
    pc.printf("init\r\n");
#endif
    irrecv.enableIRIn();
    led_4 = 0;
    while(!is_start_received())
    {
#ifdef PRINTF
        pc.printf("waiting for start signal\r\n");
        pc.printf("results.value : %x", results.value);
#endif
        wait(0.5);
        led_4 = !led_4;
    }
    while(!is_stop_received())
    {
        led_4 = 0;
        led_3 = 1;
    }
    
    led_4 = 0;
    led_3 = 0;
}