#ifndef FOODS_H
#define FOODS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class foods
{

public:
    foods();
    ~foods();

    void init(int x,int size,int velocity);
    /**
     * @param N5110 @details LCD screen
     * @brief Displays food on screen
     */
    void draw(N5110 &lcd);
    // accessors and mutators
    /** 
     * @returns The new coordinate of foods
     * @brief Updates the position of foods
     */
    void update();
    /** 
     * @returns The new coordinate of foods
     * @brief Resets the position of foods
     */
    void replace();
    /** 
     * @returns The coordinate of foods
     * @brief Retrieves the position of foods
     */
    Vector2D get_pos();
    
private:

    int _size; // the radius of the foods
    int _x;
    int _y;
    int _velocity;
};
#endif