///////// pre-processor directives ////////
/*
ELEC2645 Embed Systems Project
School of Electronic &Electrical Engineering
University of Leeds

Name:Liu Liting
Username:el17ll
Student ID Number: ID For LEEDS:201199465  ID For SWJTU:2017110353
Date: 15/05/2020
*/
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Engine.h"

#define THE_WALL_WIDTH 2
#define THE_WALL_GAP 12
#define ROCKET_SIZE 2
#define FOODS_SIZE 2
#define SPEED 2

/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
    Vector2D mapped_coord;
};
/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Engine eng;

///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void renders();
void beginning();
void end_game();
void introduction();
void finger_snap();

///////////// Images ///////////////
const int symbol1[25][32] = {
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,1,1,0,0,1,0,1,0,1,1,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,1,1,0,1,1,0,0,0,1,0,0,1,1,1,0,1,1,0,1,0,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,0 },
    { 0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0 },
    { 0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },


};

const int symbol2[25][32] = {
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0 },
    { 0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,1,0,0,1,0,1,1,1,0,0 },
    { 0,0,1,1,1,0,0,1,1,0,0,1,0,0,0,0,1,1,0,0,1,0,1,0,1,1,0,1,1,1,0,0 },
    { 0,0,0,1,0,0,0,1,1,0,1,1,0,0,0,1,0,0,1,1,1,0,1,1,0,1,0,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },

};


//////////////// the main functions //////////////////////
int main() {
    while (1) {
        int fps = 6;
        
        init();     // initialise and then display  screen...
        beginning();
        introduction(); // The intro of the story
        renders();
        wait(1.0f/fps);  // and wait for one frame period
    
        while (1) {
            eng.read_input(pad);
            eng.update(pad);
            renders();
            wait(1.0f/fps);
            if (eng.get_final_score() < 3) { // setting diffculty to regard the current ffoods number
                fps = 6;
            }
            if (eng.get_final_score() == 3) {
                fps = 9;
            }
            if (eng.get_final_score() == 4) {
                fps = 12;
            }
            if (eng.get_final_score() == 5) {
                fps = 15;
            }
            if (eng.get_final_score() == 6) { // you win!!
                finger_snap();
                break;
            } else if (eng.get_final_score() < 0) { // you lose :(
                end_game();
                break;
            }
        }
    }
}

/////////////the introduction part////////////////
const int introduction1[8][84] = {
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 1,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0 },
    { 1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1 },
    { 1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1 },
    { 1,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0 },
    { 1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
};
const int introduction2[8][80] = {
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
};
const int introduction3[8][80] = {
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
};

const int intro3[16][18] = {
    { 0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0 },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0 },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0 },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0 },
    { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0 },
};

void init() {
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
    // initialise the game with correct ball and paddle sizes
    eng.init(THE_WALL_WIDTH,THE_WALL_GAP,FOODS_SIZE,SPEED);
}

void beginning() {
    lcd.clear();
    lcd.printString("The power food",0,0); //play messages
    lcd.printString("Start story",9,4);
    lcd.drawSprite(25,8,25,32,(int *)symbol1);
    lcd.refresh();
    pad.tone(440.00,0.60); // adding the theme music, which is my favorite song(hei,hei)
    wait(0.60);
    pad.tone(329.63,0.60);
    wait(0.60);
    pad.tone(392.00,0.60);
    wait(0.60);

    pad.tone(392.00,0.30);
    wait(0.30);
    pad.tone(293.66,0.30);
    wait(0.30);
    pad.tone(293.66,0.30);
    wait(0.30);
    pad.tone(261.63,0.30);
    wait(0.30);
    pad.tone(293.66,0.30);
    wait(0.30);
    pad.tone(261.63,0.30);
    wait(0.30);
    pad.tone(392.00,0.30);
    wait(0.30);
    pad.tone(293.66,0.15);
    wait(0.30);
    pad.tone(261.63,0.15);
    wait(0.30);
    pad.tone(293.66,0.30);
    wait(0.30);
    pad.tone(392.00,0.30);
    wait(0.30);

    while (pad.check_event(Gamepad::START_PRESSED) == false) { // animation loop until start button is pressed
        lcd.clear();
        lcd.printString("Look for food",0,0);
        lcd.printString("Start story",9,4);
        lcd.drawSprite(25,8,25,32,(int *)symbol1);
        lcd.refresh();
        wait(0.5);
        lcd.clear();
        lcd.printString("Look for food",0,0);
        lcd.printString("Start story",9,4);
        lcd.drawSprite(25,8,25,32,(int *)symbol2);
        lcd.refresh();
        wait(0.5);
    }
}

void introduction() { // background story
    lcd.clear();
    lcd.printString("Liu Liting",0,0);
    lcd.printString("ID:201199465",0,4);
    lcd.refresh();
    wait(1.0);
    lcd.clear();
    lcd.printString("long long ago",0,0);
    lcd.refresh();
    wait(1.0);
    lcd.printString("Since the",6,2);
    lcd.printString("earth destoried",0,3);
    lcd.printString("we need go",9,4);
    lcd.printString("to find",18,5);
    lcd.refresh();
    wait(1.0);
    lcd.printString("(Press start)",3,1);
    wait(1.0);
    while (pad.check_event(Gamepad::START_PRESSED) == false) { // while-looping until the button is on
        lcd.refresh();
        wait(0.5);
    }
    
    lcd.clear(); // background story
    lcd.printString("You will ",12,0);
    lcd.printString("control them",9,1);
    lcd.printString("to get what",6,2);
    lcd.printString("you need to",9,3);
    lcd.printString("then travel in",0,4);
    lcd.printString("the forest",3,5);
    lcd.refresh();
    wait(1.0);
    while ( pad.check_event(Gamepad::START_PRESSED) == false) { // while-looping until the button is on
        lcd.refresh();
        wait(0.5);
    }
    
    while (pad.check_event(Gamepad::START_PRESSED) == false) { // tutorial with animation
        lcd.clear();
        lcd.printString("Useing your",10,0);
        lcd.printString("joystick to",8,1);
        lcd.printString("send yourself",2,2);
        lcd.printString("to the right",5,3);
        lcd.printString("forest",17,4);
        lcd.drawSprite(2,40,8,80,(int *)introduction1);
        lcd.refresh();
        wait(0.5);
        lcd.clear();
        lcd.printString("Useing your",10,0);
        lcd.printString("joystick to",8,1);
        lcd.printString("send yourself",2,2);
        lcd.printString("to the right",5,3);
        lcd.printString("forest",17,4);
        lcd.drawSprite(2,40,8,80,(int *)introduction2);
        lcd.refresh();
        wait(0.5);
        lcd.clear();
        lcd.printString("Useing your",10,0);
        lcd.printString("joystick to",8,1);
        lcd.printString("send yourself",2,2);
        lcd.printString("to the right",5,3);
        lcd.printString("forest",17,4);
        lcd.drawSprite(2,40,8,80,(int *)introduction3);
        lcd.refresh();
        wait(0.5);
    }
    
    while (pad.check_event(Gamepad::START_PRESSED) == false) { // tutorial with animation
        lcd.clear();
        lcd.printString("try not to",0,0);
        lcd.printString("interrupt it",0,1);
        lcd.printString("line when",0,3);
        lcd.printString("pass thro.",0,4);
        lcd.printString("the gap",0,5);
        lcd.drawSprite(54,16,16,18,(int *)intro3);
        lcd.drawRect(78,0,2,18,FILL_BLACK);
        lcd.drawRect(78,30,2,18,FILL_BLACK);
        lcd.refresh();
        wait(0.5);
        lcd.clear();
        lcd.printString("try not to",0,0);
        lcd.printString("interrupt it",0,1);
        lcd.printString("line when",0,3);
        lcd.printString("pass thro.",0,4);
        lcd.printString("the gap",0,5);
        lcd.drawSprite(62,16,16,18,(int *)intro3);
        lcd.drawRect(78,0,2,18,FILL_BLACK);
        lcd.drawRect(78,30,2,18,FILL_BLACK);
        lcd.refresh();
        wait(0.5);
    }
    
    lcd.clear(); // last message before the game begins
    lcd.printString("rearch 6",12,0);
    lcd.printString("foods and then",0,1);
    lcd.printString("win the game",6,2);
    lcd.printString("God speed",15,3);
    lcd.printString("Going!",15,4);
    lcd.refresh();
    wait(0.5);
    
    while (pad.check_event(Gamepad::START_PRESSED) == false) { //sparking leds
        pad.leds_on();
        wait(0.25);
        pad.leds_off();
        wait(0.25);
    }
}

void renders() {
    // clear screen, re-draw and refresh
    lcd.clear();  
    eng.draw(lcd);
    lcd.refresh();
}

void finger_snap() {
    lcd.clear(); // at this point the game has broken the while loop, clear screen to display congrat message
    lcd.printString("Congrat!!",17,0);
    lcd.printString("Liu Liting",0,1);
    lcd.printString("201199465",15,2);
    lcd.refresh();
    
    pad.tone(440.00,0.60); // adding the theme music
    wait(0.60);
    pad.tone(329.63,0.60);
    wait(0.60);
    pad.tone(392.00,0.60);
    wait(0.60);
    pad.tone(392.00,0.30);
    wait(0.30);
    pad.tone(293.66,0.30);
    wait(0.30);
    pad.tone(293.66,0.30);
    wait(0.30);
    pad.tone(261.63,0.30);
    wait(0.30);
    pad.tone(293.66,0.30);
    wait(0.30);
    pad.tone(261.63,0.30);
    wait(0.30);
    pad.tone(392.00,0.30);
    wait(0.30);
    pad.tone(293.66,0.15);
    wait(0.30);
    pad.tone(261.63,0.15);
    wait(0.30);
    pad.tone(293.66,0.30);
    wait(0.30);
    pad.tone(392.00,0.30);
    wait(0.30);
    while (pad.check_event(Gamepad::START_PRESSED) == false) { // enter loop waiting to restart the game
        lcd.printString("press start",9,4);
        lcd.printString("to return",15,5);
        lcd.refresh();
        pad.leds_on();
        wait(0.5);
        pad.leds_off();
        wait(0.5);
    }
}

void end_game() {
    lcd.clear(); //break the while loop and enter gameover
    lcd.printString("OH!!!",18,1);
    lcd.printString("I don't feel",6,2);
    lcd.printString("so good ...",9,3);
    lcd.refresh();
    
    pad.tone(261.63,1.63); // play sad music when lose
    wait(1.63);
    pad.tone(0.0,0.06);
    wait(0.06);
    pad.tone(261.63,0.63);
    wait(0.63);
    pad.tone(293.66,0.63);
    wait(0.06);
    pad.tone(329.63,0.63);
    wait(0.63);
    pad.tone(261.63,0.63);
    wait(0.06);
    pad.tone(329.63,1.63);
    wait(1.63);
    pad.tone(0.00,0.06);
    wait(0.06);
    pad.tone(261.63,0.63);
    wait(0.63);
    pad.tone(293.66,0.63);
    wait(0.63);
    pad.tone(329.63,0.63);
    wait(0.63);
    pad.tone(261.63,0.63);
    wait(0.63);
    pad.tone(349.23,0.63);
    wait(0.63);

    while (pad.check_event(Gamepad::START_PRESSED) == false) { // enter loop waiting to restart the game
        lcd.printString("press start",9,4);
        lcd.printString("to return",15,5);
        lcd.refresh();
        wait(0.5);
    }
}