// uLCD-144-G2 different fonts
//
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"

uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
PinDetect pb1(p15);
PinDetect pb2(p16);
PinDetect pb3(p17);

int volatile sizeCount=1;       //font size count, set to 1 initially
int volatile fontCount=0;       //font count
int volatile isInterrupted=1;   //indicate an interrupt
 
//pb1 to increase font size
void pb1_hit_callback (void) {
    if (sizeCount < 4) {sizeCount++;}
    uLCD.cls();
    isInterrupted=1;
}

//pb2 to decrease font size
void pb2_hit_callback (void) {
    if (sizeCount > 1) {sizeCount--;}
    uLCD.cls();
    isInterrupted=1;
}

//pb3 changes font. Loops through default, comic sans, tahoma, and courier new
void pb3_hit_callback (void) {
    if (fontCount < 3) {fontCount++;}
    else {fontCount = 0;}
    uLCD.cls();
    isInterrupted=1;
}

int main()
{
    pb1.mode(PullUp);    
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    uLCD.media_init(); // initialize uSD card
    uLCD.printf("\n  Hello\n  Font\n  World");
    while (1) {
        //change font settings if a button is pushed
        if(isInterrupted == 1) {
            uLCD.cls();
            isInterrupted = 0;
            //comic sans
            if(fontCount == 1) {
                uLCD.set_sector_address(0,0);
                uLCD.set_font(MEDIAFONT);
            }
            //tahoma
            else if(fontCount == 2) {
                uLCD.set_sector_address(0,0xE);
                uLCD.set_font(MEDIAFONT);
            }
            //courier new
            else if(fontCount == 3) {
                uLCD.set_sector_address(0,0x1C);
                uLCD.set_font(MEDIAFONT);
            }
            //default font
            else {
                uLCD.set_sector_address(0,0);
                uLCD.set_font(FONT_7X8);
            }
            //increase or decrease font
            uLCD.text_width(sizeCount); //1X size text
            uLCD.text_height(sizeCount);    
            uLCD.printf("\n  Hello\n  Font\n  World");
        }

    }
}