#include "mbed.h"
#include "mlx90614.h"
#include "uLCD_4DGL.h"

I2C i2c(p28,p27);   //sda,scl

MLX90614 IR_thermometer(&i2c);
//setup an MLX90614 using MLX90614 library from
// http://mbed.org/users/aquahika/libraries/MLX90614/lsixz6

DigitalIn sw(p20);

Serial pc(USBTX, USBRX);

Serial xbee1(p9,p10);

uLCD_4DGL uLCD(p13,p14,p11);

DigitalOut myled(LED1);
DigitalOut myled3(LED3);//Create variable for Led 3 on the mbed

int main() {
    
    sw.mode(PullUp);
    
    float current_temp = 0.0;
    
    wait(5.0);
    uLCD.printf("Your temp is:");
    while (1) {
        wait(1.0);
        myled=1; // if led1 on - waiting on I2C
        if (IR_thermometer.getTemp(&current_temp)) {
        //gets temperature from sensor via I2C bus
       
        if (sw == 1) {
            xbee1.printf("%d \n\r", (int) current_temp);
        }
        //pc.printf("data %d \n\r", (int) current_temp);
        myled=0;
        uLCD.text_height(3);
        uLCD.text_width(3);
        uLCD.locate(1,2);
        uLCD.printf("%d C", (int) current_temp);
        wait(0.3);
        myled3=1;
        wait(1.0); 
        //wait for device to produce next temperature reading        
        }
    }
}