#include "mbed.h"
#include "rtos.h"
#include "Motor.h"
#include "uLCD_4DGL.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
 
#define Room_TempC 23.0
#define Room_TempF 78.0
//#define Normal_BTempC 30.0
#define Normal_BTempF ((9.0/5.0)*Normal_BTempC) + 32
 
Motor m(p21, p19, p20); // pwm, fwd, rev 
  
DigitalOut myled(LED1);
DigitalOut myLED2(LED2);
DigitalOut myLED3(LED3);
DigitalOut myLED4(LED4);

InterruptIn pb1(p30);
InterruptIn pb2(p29);

uLCD_4DGL uLCD(p13,p14,p11);
 
Serial pc(USBTX, USBRX);
Serial xbee1(p9, p10); 
DigitalOut rst1(p8);

EthernetInterface ethif;
HTTPClient http;
 
enum Statetype { ac_off = 0, ac_on };
volatile int sensor_data; 
volatile int Normal_BTempC = 30;
 
void receiver_thread(void const * argument){
    
    rst1 = 0;   //Set reset pin to 0
    myled = 0;
    Thread::wait(1);
    rst1 = 1;   //Set reset pin to 1
    Thread::wait(1);
    
    uLCD.printf("Set Temp:");
    uLCD.locate(0,7);
    uLCD.printf("Your Temp:");            
   
    while (1) { 
        Thread::wait(500);
        myled = 1;        
        if(xbee1.readable()){            
            xbee1.scanf("%d\n", &sensor_data);            
            //pc.printf("data received %d\n\r", sensor_data);
            uLCD.text_height(2);
            uLCD.text_width(2);
            uLCD.locate(2,2);
            uLCD.printf("%d C", Normal_BTempC);
            uLCD.locate(2,6);
            uLCD.printf("%d C", sensor_data);
            Thread::wait(300);                         
            myled = 0; 
            Thread::wait(1000);                     
        }
    }
}

void changeBTemp_thread(void const *argument) {
    while (1) {
        pb1.mode(PullUp);
        pb2.mode(PullUp);
        if (pb1 == 0) {Normal_BTempC++;};
        if (pb2 == 0) {Normal_BTempC--;};
        Thread::wait(500);
    }
}

void network_thread(void const *argument) {
    
    char urlBuffer[256];
    char str[512];
    
    ethif.init(); //Use DHCP
    ethif.connect(60000);
    pc.printf("connected ethernet\n");
   
    while (1)
    {
       // initialize ethernet hardware
       pc.printf("Begin While loop");
       
    
        urlBuffer[0] = 0;
        str[0]=0;
        sprintf(urlBuffer, "http://api.thingspeak.com/update?key=LRZ7ZLXUI7LKC470&field1=%d", sensor_data);
        
        http.get(urlBuffer, str,128);
        //HTTPResult res = http.get(urlBuffer, str,128);
        //if(res==0) {
        //pc.printf("sent get to thingspeak\n");
        //}
        //else {
         //   pc.printf("get failed to send");
          //  }
       // wait(16); // 1 minute
       // led=!led;
        Thread::wait(10000);
    
    }
}
int main() {
    
    Thread thread1(receiver_thread);
    Thread::wait(5000);
    Thread thread2(changeBTemp_thread);
    Thread::wait(5000);
    Thread thread3(network_thread);
    Statetype state = ac_off;
    
    while(1){
    myLED3 = !myLED3;
    //uLCD.printf("Set Temp: %d\n\r", Normal_BTempC);
        switch (state) {
            case ac_off:
                
                m.speed(0.0); 
                myled = 1;
                myLED2 =0;
                myLED3 =1;
                myLED4 =0;
                
                Thread::wait(3000);
                
                (sensor_data >= Normal_BTempC)? state = ac_on : state = ac_off;
                //pc.printf("This is off \n\r");
                break;

            case ac_on:
                   
                myled = 1;
                myLED2 =1;
                myLED3 =1;
                myLED4 =1;
                   
                while (sensor_data >= 1.3*Normal_BTempC) {
                    m.speed(1.0);
                }
                while ((sensor_data >= 1.2*Normal_BTempC)&&(sensor_data < 1.3*Normal_BTempC)) {
                    m.speed(0.5);
                    Thread::wait(500);
                    m.speed(0.0);
                    Thread::wait(2000);
                }
                while ((sensor_data >= 1.1*Normal_BTempC)&&(sensor_data < 1.2*Normal_BTempC)) {
                    m.speed(0.5);
                    Thread::wait(500);
                    m.speed(0.0);
                    Thread::wait(3000);
                }
                while ((sensor_data >= Normal_BTempC)&&(sensor_data < 1.1*Normal_BTempC)) {
                    m.speed(0.5);
                    Thread::wait(500);
                    m.speed(0.0);
                    Thread::wait(3500);
                }                    
                                     
                //m.speed(1.0);
                (sensor_data < Normal_BTempC)? state = ac_off : state = ac_on;
                //pc.printf("This is on \n\r");
                break;
        }
        Thread::wait(1000);
    }
}