#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(D11, D12, D13, D10, "sd"); // MOSI, MISO, SCK, CS: SPI1
//SDFileSystem sd(D4, D5, D3, D2, "sd");     // MOSI, MISO, SCK, CS: SPI3
//原平台LPC1768 (p11, p12, p13, p8, "sd");
//              mosi,miso,sck,cs,
//  nucleo       D11,D12,D13,D10

Serial pc_(USBTX, USBRX);

int main() {
    pc_.baud(115200);
    pc_.printf("\r\nInitializing\r\n");

    // 書き込みのテスト == Test writing
    pc_.printf("\nWriting to SD card...: ");
    //mkdir("/sd/mydir", 0777); //criar uma pasta
    //FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");//"w" para criar o ficheiro limpo, "a" para append (adicionar ao ficheiro)
    FILE *fp = fopen("/sd/sdtest.txt", "a+");   // additional writing
    
    if (fp != NULL)
    {
        fprintf(fp, "SD sdsdsd"); //texto a escrever no ficheiro
        fclose(fp);
        pc_.printf("success!\r\n");
    }
    else
        pc_.printf("failed!\r\n");
 
    // 読み出しのテスト == Test readout
    pc_.printf("Reading from SD card...:\r\n");
    fp = fopen("/sd/sdtest.txt", "r");
    if (fp != NULL)
    {
        char str[256];
        while (fgets(str, 256, fp) != NULL)
            pc_.printf("%s", str);
        
        fclose(fp);
        pc_.printf("\r\nsuccess!\r\n");
    }
    else
        pc_.printf("failed!\r\n");
 
    while (true) {}
}
