#include <mbed.h>

#include "USBControl.h"

#define VENDOR_ID 0x0004
#define PRODUCT_ID 0x0307
#define PRODUCT_RELEASE 0x0001
#define PRODUCT_NAME "Knob"
#define MANUFACTURER_NAME "Me"
#define WINUSB_GUID "{a451588c-7230-4076-8456-9e544165e90c}"

class USBKnob : public USBControl
{
public:
    USBKnob() : USBControl(VENDOR_ID, PRODUCT_ID, PRODUCT_RELEASE, PRODUCT_NAME, MANUFACTURER_NAME, WINUSB_GUID)
    {
    }
    
    void send(uint32_t fraction)
    {
        sendData(reinterpret_cast<uint8_t*>(&fraction), sizeof(fraction));
    }
};


//DigitalOut red(LED_RED);
//DigitalOut green(LED_GREEN);
//DigitalOut blue(LED_BLUE);

AnalogIn knob(PTC2);

// ReadKnob reads the knob until the value is sufficiently
// changed from the previousValue. The longer time goes on the
// more the difference has to be (up to a point).
//
// Values are 16 bit.
int ReadKnob(int previousValue)
{
    int centiseconds = 0;
    
    for (;;)
    {
        int val = knob.read_u16();
        
        int difference = abs(val - previousValue);
        
        // TODO: Check these.
        if (centiseconds < 10 && difference > 100)
            return val;
        else if (difference > 1000)
            return val;
        
        Thread::wait(10);
        if (centiseconds < 1000)
            ++centiseconds;
    }
}

int main(int argc, char* argv[])
{
    // So, for some reason this doesn't work with mBed OS 5.
    
    USBKnob usb;

    usb.connect();
    
    // We'll use a time-dependent threshold. Basically we take the time
    // since we sent the last value, and then plug it into some kind of
    // curve to give a threshold. Then we compare the current value to
    // the previous value, and if the difference is greater than the threshold
    // we send it.
    
    const int THRESHOLD = 0x0100; // 1/256

    int val = knob.read_u16();
    
    for (;;)
    {
        val = ReadKnob(val);
        usb.send(static_cast<uint32_t>(val) << 16);
    }
    return 0;
}