#pragma once

#include "WinUSBDevice.h"

#include <string>
#include <vector>

class USBControl : public WinUSBDevice
{
public:
    USBControl(uint16_t vendor_id, uint16_t product_id, uint16_t product_release, const char* product_name, const char* manufacturer_name, const char* guid);
    
protected:
    /*
    * Called by USBDevice layer. Set configuration of the device.
    * For instance, you can add all endpoints that you need on this function.
    *
    * @param configuration Number of the configuration
    * @returns true if class handles this request
    */
    bool USBCallback_setConfiguration(uint8_t configuration);

    /*
    * Get string product descriptor
    *
    * @returns pointer to the string product descriptor
    */
    uint8_t* stringIproductDesc();

    /*
    * Get string interface descriptor
    *
    * @returns pointer to the string interface descriptor
    */
    uint8_t* stringIinterfaceDesc();
    
    /*
    * Get string manufacturer descriptor
    *
    * @returns pointer to the string manufacturer descriptor
    */
    uint8_t* stringImanufacturerDesc();

    /*
    * Get configuration descriptor
    *
    * @returns pointer to the configuration descriptor
    */
    uint8_t* configurationDesc();
    
    // Send data on our interrupt endpoint. Blocking. Returns true on success.
    // Maximum length is MAX_PACKET_SIZE_EPINT
    bool sendData(const std::string& data);
    bool sendData(const uint8_t* data, int len);
    
    // Send data on our intterup endpoint. Non-blocking. Returns true on success.
    // Maximum length is MAX_PACKET_SIZE_EPINT
    bool sendDataNB(const std::string& data);
    bool sendDataNB(const uint8_t* data, int len);
    
    // Wait until there is a packet available, then receive it. Returns an empty string on failure or empty packet.
    std::string receiveData();
    // Immediately check if any packets are available and receive them. Returns an empty string on failure, or an empty packet, or if no data is available.
    std::string receiveDataNB();

protected:    
    // Called when data is set to EPINT_OUT (AKA EP1_OUT).
    bool EPINT_OUT_callback();

private:
    std::vector<std::string> mReceivedPackets;
    
    std::vector<uint8_t> mProductStringDescriptor;
    std::vector<uint8_t> mManufacturerStringDescriptor;
};