#include "TPM_init.h"
 
void TPM0_init(unsigned int modulo_val, unsigned int prescale_val){
    volatile unsigned int *ptrMyReg;
    unsigned int prev;
    
    //ptrMyReg = (volatile unsigned int *) MCG_C1_ADDR;
    //pc.printf("MCG_C1 = 0x%x ", *ptrMyReg);
    
    ptrMyReg = (volatile unsigned int *) SIM_SOPT2_ADDR;
    prev = *ptrMyReg;
 
    SIM->SOPT2 |= SIM_SOPT2_PLLFLLSEL_MASK;
    SIM->SOPT2 &= ~(SIM_SOPT2_TPMSRC_MASK);
    SIM->SOPT2 |= SIM_SOPT2_TPMSRC(1);
    
    /*
    //pc.printf("Previous value of SIM_SOPT2 = 0x%x ", *ptrMyReg);
    //prev = prev & 0xFDFEFFFF;  //16:PLLFLLSEL, 0:MCFGFLLCLK, 1:MCGPLLCLK/2  
    prev = prev & 0xFDFFFFFF;  //16:PLLFLLSEL, 0:MCFGFLLCLK, 1:MCGPLLCLK/2  
    //pc.printf("prev after AND MASK = %x", prev);
    prev = prev | 0x01000000;
    //pc.printf("prev after AND MASK = %x", prev);
    *ptrMyReg = prev;
    //*ptrMyReg = prev | 0x01000000;  //25-24: TPMSRC, 01:MCGFLLCLK or MCFGPLLCLK/2
    //*ptrMyReg = 0x05010000;
    
    //pc.printf("SIM_SOPT2 = 0x%x\n", *ptrMyReg);
    */
    
    SIM->SCGC6 |= SIM_SCGC6_TPM0_MASK;
    
    /*
    ptrMyReg = (volatile unsigned int *) SIM_SCGC6_ADDR; //bit [26-24]
    prev = *ptrMyReg;
    prev = prev | 0x07000000;
    *ptrMyReg = prev;
    //pc.printf("New value of SIM_SCGC6 = 0x%x ", *ptrMyReg); 
    */
    
    //Set all bits to zero
    TPM0->SC = 0x0;
    
    /*
    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    *ptrMyReg = 0x0;
    //pc.printf("TPM0_SC = 0x%x\n", *ptrMyReg);
    */
    
    //No channels for now
    /*
    ptrMyReg = (volatile unsigned int *) TPM0_C0SC_ADDR; 
    prev = *ptrMyReg;
    prev = prev | 0x00000040;
    *ptrMyReg = prev;
    //pc.printf("TPM0_C0SC = 0x%x\n", *ptrMyReg);
    */
    
    //Reset COUNT value to zero
    TPM0->CNT = 0x0;
    /*
    ptrMyReg = (volatile unsigned int *) TPM0_CNT_ADDR; //all bits set to 0
    *ptrMyReg = 0x0;
    //pc.printf("TPM0_CNT = 0x%x\n", *ptrMyReg);
    */
    
    //Set modulo value
    TPM0->MOD = modulo_val;
    /*
    ptrMyReg = (volatile unsigned int *) TPM0_MOD_ADDR; 
    *ptrMyReg = modulo_val;
    //*ptrMyReg = 0xFFFF;
    //pc.printf("TPM0_MOD = 0x%x\n", *ptrMyReg);
    */
    
    //Set prescale value
    TPM0->SC |= prescale_val;
    
    //Enable overflow interrupt
    TPM0->SC |= TPM_SC_TOIE_MASK;
    
    /*
    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; 
    *ptrMyReg = 0x00000040; //bit [6]:1, Enable Overflow Interrupts
    //pc.printf("TPM0_SC = 0x%x\n", *ptrMyReg);
    */
    
    
    
    
    //Enable reset after overflow [27:24} Trigger, 1000: TPM0 overflow, [18]:counter reload on trigger
/*    ptrMyReg = (volatile unsigned int *) TPM0_CONF_ADDR;
    //prev = *ptrMyReg;
    //prev = prev | 0x08000000;
    //pc.printf("TPM0_CONF = 0x%x\n", *ptrMyReg);
    *ptrMyReg = 0x08040000;
*/    
    
}
 
unsigned int TPM0_SC_read() {
    unsigned int SC_value = TPM0->SC;
    return SC_value;
    /*
    volatile unsigned int *ptrMyReg;
    unsigned int value;
    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    value = *ptrMyReg;
    return value;
    */
}
unsigned int TPM0_CNT_read() {
    unsigned int CNT_value = TPM0->CNT;
    return CNT_value;
    /*
    volatile unsigned int *ptrMyReg;
    unsigned int value;
    ptrMyReg = (volatile unsigned int *) TPM0_CNT_ADDR; //all bits set to 0
    value = *ptrMyReg;
    return value;
    */
}
 
void TPM0_clear_overflow() {
    TPM0->SC |= TPM_SC_TOF_MASK;
    /*
    volatile unsigned int *ptrMyReg;
    
    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    *ptrMyReg = 0x000000C8;     //bit[4:3]: 0x01, on every TPM counter clk
    //*ptrMyReg = 0x00000088;     //Debugging handler. Try disabling overflow interrupts
    //*ptrMyReg = 0x00000050;     //bit[4:3]: 0x10, on every rising edge of external ....
    */
}
 
void TPM0_start() {   
    
    TPM0->SC |= TPM_SC_CMOD(1); //Count on every TPM counter clk
    /*
    volatile unsigned int *ptrMyReg;
    
    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    *ptrMyReg = 0x00000048;     //bit[4:3]: 0x01, on every TPM counter clk
    */
}    